package com.quant.dao;

import java.util.List;

import com.quant.annotation.MyBatisRepository;
import com.quant.entity.City;
import com.quant.entity.Company;
import com.quant.entity.Province;
import com.quant.vo.PageVo;

@MyBatisRepository
public interface CompanyMapper extends Mapper {
	List<Company> findAllCompany();
	void addCompany(Company obj);
	List<Company> findSimpleCompany();
	void modifyCompany(Company obj);
	Province findProvinceById(Integer id);
	List<Province> findAllProvince();
	City findCityById(Integer id);
	List<City> findCityByProvinceId(Integer id);
    Integer findRows();
    List<Company> findSimpleCompanyByPage(PageVo pageVo);
    
    //根据公司名字查找公司信息
    Company findByCompanyName(String companyName);
   //查找公司最大company_id
    Integer findMaxCompanyId();
    
}
