package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.dao.SmsMapper;
import com.quant.vo.PageVo;
import com.quant.vo.SmsPageVo;
import com.quant.entity.Sms;


/**
 * 处理资讯的控制层
 * @author Administrator
 *
 */
@Controller
@RequestMapping("/operation/sms")
public class SmsController {
	
	@Resource
	SmsMapper smsMapper;
	@RequestMapping("/index.do")
	public String index(){
		return "sms/index";
	}
	
	@RequestMapping("/list.do")
	public String findNews(ModelMap map,SmsPageVo pageVo){
		
		//查询出总行数，计算总页数，发送至页面，用于循环输出页码
		//将当前页传到页面用于勾选当前页：总页数、当前页传至页面
		int rows=smsMapper.findRows();
		pageVo.setRows(rows);
		//默认情况下使用request传递该变量的值，使用注解@SessionAttributes("newsPageVo")
		//后使用session传递
		List<Sms> sms=smsMapper.findSmsByPage(pageVo);
		map.put("smses", sms);
		map.addAttribute("pageVo", pageVo);
		map.addAttribute("showPages", pageVo.getShowPages());
		return "sms/list";
	}
	
	@RequestMapping("detailSms.do")
	public String getSms(ModelMap map, Integer id){
		Sms sms = smsMapper.findById(id);
		map.put("sms", sms);
		return "sms/detail";
	}
	
	@RequestMapping("deleteSms.do")
	public String deleteSmsById(Integer id){
		smsMapper.deleteById(id);
		return "redirect:list.do";
	}
	
}