package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.quant.comm.ReadPro;
import com.quant.dao.SettingMapper;
import com.quant.entity.CommonCategory;
import com.quant.entity.CommonSubclass;
import com.quant.vo.PageVo;
import com.quant.vo.SubclassPageVo;

/**
 * 处理类别的控制层
 * @author Administrator
 *
 */
@Controller
@RequestMapping("/operation/setting")
public class SettingController {
	@Resource
	SettingMapper settingMapper;
	@Resource
	private ReadPro readPro;
	
	/**
	 * 查找所有的分类--最大类
	 * @param map
	 * @return
	 */
	@RequestMapping("/findCategory.do")
	
	public String findCategory(ModelMap map,PageVo pageVo){
		int rows=settingMapper.findRows();
		pageVo.setRows(rows);
		List<CommonCategory> list=settingMapper.findCategoryByPage(pageVo);
		map.put("category", list);
		map.addAttribute("pageVo", pageVo);
		map.addAttribute("showPages", pageVo.getShowPages());
		return "setting/category";
	}
	/**
	 * 编辑分类--最大类的中转控制层
	 * 跳转到编辑页面
	 * @return
	 */
	@RequestMapping("/toUpdateCategory.do")
	public String toUpdateCategory(Integer categoryId,ModelMap map){
		CommonCategory category=settingMapper.findCategoryByCategoryId(categoryId);
		map.addAttribute("category", category);
		return "setting/category_update";
	}
	/**
	 * 编辑修改分类--最大类
	 * @param category
	 * @return
	 */
	@RequestMapping("/updateCategory.do")
	public String updateCategory(CommonCategory category){
		if(category.getStatus()==null||category.getStatus().equals("")){
			category.setStatus(0);
		}
		if(category.getMultiHierarchy()==null||category.getMultiHierarchy().equals("")){
			category.setMultiHierarchy(0);
		}
		settingMapper.updateCategory(category);
		return "redirect:findCategory.do";
	}
	/**
	 * 新增分类--最大类中转控制层
	 * 跳转到新增页面
	 * @return
	 */
	@RequestMapping("/toAddCategory.do")
	public String toAddCategory(){
		return "setting/category_add";
	}
	/**
	 * 新增分类--最大类
	 * @param category
	 * @return
	 */
	@RequestMapping("/addCategory.do")
	public String addCategory(CommonCategory category){
		//查找表common_category主键最大值，将其+1赋值给category_id
		Integer maxId=settingMapper.findCategoryMaxId();
		if(maxId==null){
			maxId=Integer.parseInt(readPro.readProperties("category_id_min"));
		}
		category.setCategoryId(maxId+1);
		
		if(category.getStatus()==null||category.getStatus().equals("")){
			category.setStatus(0);
		}
		if(category.getMultiHierarchy()==null||category.getMultiHierarchy().equals("")){
			category.setMultiHierarchy(0);
		}
		settingMapper.addCategory(category);
		return "redirect:findCategory.do";
	}
	/**
	 * 根据categoryId查找子类--subclass
	 * @param map
	 * @return
	 */
	@RequestMapping("/findSubclass.do")
	public String findSubclass(Integer categoryId,ModelMap map,SubclassPageVo pageVo){
		pageVo.setCategoryId(categoryId);
		Integer rows=settingMapper.findSubclassRows(categoryId);
		pageVo.setRows(rows);
		map.addAttribute("subclassPageVo", pageVo);
		List<CommonSubclass> list=settingMapper.findSubclassByCategoryIdAndPage(pageVo);
		map.put("subclass", list);
		String title=settingMapper.findTitleByCategoryId(categoryId);
		map.addAttribute("title", title);
		map.addAttribute("categoryId",categoryId);
		map.addAttribute("showPages", pageVo.getShowPages());
		return "setting/subclass";
	}
	/**
	 * 编辑分类--subclass的中转控制层
	 * 跳转到subclass编辑页面
	 * @param id
	 * @param map
	 * @return
	 */
	@RequestMapping("/toUpdateSubclass.do")
	public String toUpdateSubclass(Integer subclassId,Integer categoryId,ModelMap map){
		CommonSubclass subclass=settingMapper.findSubclassBySubclassId(subclassId);
		List<CommonSubclass> list=settingMapper.findSubclassByCategoryId(categoryId);
		map.addAttribute("subclass", subclass);
		map.put("subclasses", list);
		return "setting/subclass_update";
	}
	/**
	 * 编辑修改分类--subclass
	 * @return
	 */
	@RequestMapping("updateSubclass.do")
	public String updateSubclass(CommonSubclass subclass){
		if(subclass.getStatus()==null||subclass.getStatus().equals("")){
			subclass.setStatus(0);
		}
		settingMapper.updateSubclass(subclass);
		return "redirect:findSubclass.do?categoryId="+subclass.getCategoryId();
	}
	/**
	 * 查看分类--subclass的中转控制层
	 * 跳转到查看subclass的页面
	 * @param pid
	 * @return
	 */
	@RequestMapping("/toListSubclass.do")
	public String toListSubclass(Integer pid,ModelMap map){
		List<CommonSubclass> list=settingMapper.findSubclassByPid(pid);
		map.put("subclass", list);
		return "setting/subclass_list";
	}
	
	/**
	 * 新增分类--subclass中转控制层
	 * 跳转到新增页面
	 * pid is null
	 */
	@RequestMapping("/selectSubclassByCategoryIdPidIsNull.do")
	@ResponseBody
	public List<CommonSubclass> toAddSubclassWherePidIsNull(Integer categoryId){
		List<CommonSubclass> list=settingMapper.findSubclassByCategoryIdWherePidIsNull(categoryId);
		
		return list;
	}
	/**
	 * 新增分类--subclass中转控制层
	 * 跳转到新增页面
	 * @param categoryId
	 * @param map
	 * @return
	 */
	@RequestMapping("toAddSubclass.do")
	public String toAddSubclass(Integer categoryId,ModelMap map){
		List<CommonSubclass> list=settingMapper.findSubclassByCategoryIdWherePidIsNull(categoryId);
		map.put("subclass", list);
		List<CommonCategory> listCategory=settingMapper.findAll();
		map.put("category", listCategory);
		map.addAttribute("categoryId", categoryId);
		return "setting/subclass_add";
	}
	/**
	 * 新增分类
	 * @param subclass
	 * @return
	 */
	@RequestMapping("/addSubclass.do")
	public String addSubclass(CommonSubclass subclass,String select01,String select02,String select03){
		if(select03!=null&&!select03.equals("")){
			subclass.setPid(Integer.parseInt(select03));
		}else if(select02!=null&&!select02.equals("")){
			subclass.setPid(Integer.parseInt(select02));
		}else if(select01!=null&&!select01.equals("")){
			subclass.setPid(Integer.parseInt(select01));
		}
		if(subclass.getStatus()==null||subclass.getStatus().equals("")){
			subclass.setStatus(0);
		}
		Integer maxId=settingMapper.findSubclassMaxId();
		if(maxId==null){
			maxId=Integer.parseInt(readPro.readProperties("common_subclass_id_min"));
		}
		subclass.setSubclassId(maxId+1);
		settingMapper.addSubclass(subclass);
		return "redirect:findSubclass.do?categoryId="+subclass.getCategoryId();
	}
	/**
	 * 异步请求处理select下拉框联动
	 * @param pid
	 * @return
	 */
	@RequestMapping("/selectSubclass.do")
	@ResponseBody
	public List<CommonSubclass> selectSubclass(Integer pid){
		List<CommonSubclass> list=settingMapper.findSubclassByPid(pid);
		return list;
	}
	/**
	 * 异步请求查询category，所有数据
	 * @return
	 */
	@RequestMapping("/seleCategory.do")
	@ResponseBody
	public List<CommonSubclass> seleCategory(Integer categoryId){
		List<CommonSubclass> list=settingMapper.findSubclassByCategoryId(categoryId);
		return list;
	}
}
