package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.quant.dao.CompanyMapper;
import com.quant.dao.MeetingMapper;
import com.quant.entity.City;
import com.quant.entity.Meeting;
import com.quant.entity.MeetingRegist;
import com.quant.entity.Province;
import com.quant.vo.MeetingPageVo;

@Controller
@RequestMapping("/operation/meeting")
public class MeetingController {
	@Resource
	private MeetingMapper meetingMapper;
	@Resource
	private CompanyMapper companyMapper;
	
	@RequestMapping("/toMeetingList.do")
	public String toMeetingList(Model model, HttpServletRequest request,MeetingPageVo pageVo){
		int rows = meetingMapper.findMeetingRows(pageVo);
		pageVo.setRows(rows);
		List<Meeting> meetings = meetingMapper.findMeetingByPage(pageVo);
		model.addAttribute("meetings", meetings);
		model.addAttribute("status", pageVo.getStatus());
		model.addAttribute("showPages", pageVo.getShowPages());
		model.addAttribute("pageVo", pageVo);
		return "meeting/meeting_list";
	}
	
	@RequestMapping("/toUpdateMeeting.do")
	public String toUpdateMeeting(Model model,Integer meetingId){
		List<Province> province = companyMapper.findAllProvince();
		Meeting meeting = meetingMapper.findMeetingByMeetingId(meetingId);
		if(meeting.getProvince()!=null){
			List<City> citys = companyMapper.findCityByProvinceId(meeting.getProvince());
			model.addAttribute("citys", citys);
		}
		model.addAttribute("meeting", meeting);
		model.addAttribute("province", province);
		return "meeting/meeting_modify";
	}
	
	@RequestMapping("/updateMeeting.do")
	public String updateMeeting(Model model,Meeting meeting,String[] editorValue){
		meeting.setAgenda(editorValue[0]);
		meeting.setDescription(editorValue[1]);
		meeting.setEnrollInfo(editorValue[2]);
		meeting.setGuest(editorValue[3]);
		meeting.setAddressInfo(editorValue[4]);
		if(meeting.getThumbnail()==""){
			meeting.setThumbnail(null);
		}
		if(meeting.getMthumbnail()==""){
			meeting.setMthumbnail(null);
		}
		if(meetingMapper.modifyMeeting(meeting)==1){
			return "redirect:toMeetingList.do";
		}
		return "meeting/error";
	}
	@RequestMapping("/toAddMeeting.do")
	public String toAddMeeting(Model model,Integer meetingId){
		List<Province> province = companyMapper.findAllProvince();
		model.addAttribute("province", province);
		return "meeting/meeting_add";
	}
	
	@SuppressWarnings("unused")
	@RequestMapping("/addMeeting.do")
	public String addMeeting(Model model,Meeting meeting,String[] editorValue){
		meeting.setAgenda(editorValue[0]);
		meeting.setDescription(editorValue[1]);
		meeting.setEnrollInfo(editorValue[2]);
		meeting.setGuest(editorValue[3]);
		meeting.setAddressInfo(editorValue[4]);
		Integer meetingId = meetingMapper.findMaxMeetingId()+1;
		if(meetingId==null){
			meetingId=1;
		}
		meeting.setMeetingId(meetingId);
		if(meeting.getThumbnail()==""){
			meeting.setThumbnail(null);
		}
		if(meeting.getMthumbnail()==""){
			meeting.setMthumbnail(null);
		}
		if(meetingMapper.addMeeting(meeting)==1){
			return "redirect:toMeetingList.do";
		}
		return "meeting/error";
	}
	
	@RequestMapping("/deleteMeeting.do")
	public String deleteMeeting(Model model,Integer meetingId){
		if(meetingId!=null&&meetingMapper.deleteMeeting(meetingId)==1){
			return "redirect:toMeetingList.do";
		}
		return "meeting/error";
	}
	
	
	
	
	@RequestMapping("/toMRList.do")
	public String toMRList(Model model,MeetingPageVo pageVo){
		int rows = meetingMapper.findRows(pageVo);
		pageVo.setRows(rows);
		List<MeetingRegist> meetingRegists = meetingMapper.findByPage(pageVo);
		model.addAttribute("meetingRegists", meetingRegists);
		model.addAttribute("status", pageVo.getStatus());
		model.addAttribute("showPages", pageVo.getShowPages());
		model.addAttribute("pageVo", pageVo);
		return "meeting/meeting_regist_list";
	}
	@RequestMapping("/toUpdateMeetingRegist.do")
	public String toUpdateMeetingRegist(Model model,Integer id){
		MeetingRegist meetingRegist = meetingMapper.findMeetingRegistById(id);
		model.addAttribute("meeting", meetingRegist);
		return "meeting/meeting_regist_modify";
	}
	
	@RequestMapping("/modifyMeetingRegist.do")
	public String modifyMeetingRegist(Model model,MeetingRegist meetingRegist){
		
		if(meetingMapper.modifyMeetingRegist(meetingRegist)==1){
			return "redirect:toMRList.do";
		}
		return "meeting/error";
	}
	@RequestMapping("/deleteMeetingRegist.do")
	public String deleteMeetingRegist(Model model,Integer id){
		if(id!=null&&meetingMapper.deleteMeetingRegist(id)==1){
			return "redirect:toMRList.do";
		}
		return "meeting/error";
	}

	
	
	
	@ResponseBody
	@RequestMapping(value="/findCityByProvinceId.do",produces = "application/json")
	public List<City> findCityByProvinceId(City city){
		List<City> list = companyMapper.findCityByProvinceId(city.getProvinceId());
		return list;
	}

}
