package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.comm.ReadPro;
import com.quant.dao.CompanyMapper;
import com.quant.dao.ManagerMapper;
import com.quant.dao.SettingMapper;
import com.quant.entity.CommonSubclass;
import com.quant.entity.Company;
import com.quant.entity.CompanyManager;
import com.quant.entity.Manager;
import com.quant.vo.PageVo;
import com.quant.vo.ManagerRelationVO;

@Controller
@RequestMapping("/operation/manager")
public class ManagerController extends BaseController {
	@Resource
	private ManagerMapper managerMapper;
	@Resource
	private CompanyMapper companyMapper;
	@Resource
	private SettingMapper settingMapper;
	@Resource
	private ReadPro readPro;
	
	@RequestMapping("/findAllManager.do")
	public String findAll(Model model){
		
		return "manager/manager_list";
	}
	@RequestMapping("/findSimpleManager.do")
	public String findSimpleManager(Model model,PageVo pageVo){
		Integer rows=managerMapper.findRows();
		pageVo.setRows(rows);
		List<ManagerRelationVO> managers = managerMapper.findSimpleManagerByPage(pageVo);
		model.addAttribute("managers", managers);
		model.addAttribute("pageVo",pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		return "manager/manager_list";
	}
	@RequestMapping("/toAddManager.do")
	public String toAddManager(Model model){
		List<Company> list = companyMapper.findSimpleCompany();
		List<CommonSubclass> practitioners = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("practitioners")));
		List<CommonSubclass> education = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("education")));
		List<CommonSubclass> entirePeriod = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("entirePeriod")));
		model.addAttribute("companys", list);
		model.addAttribute("practitioners", practitioners);
		model.addAttribute("education", education);
		model.addAttribute("entirePeriod", entirePeriod);
		return "manager/add_manager";
	}
	@RequestMapping("/addManager.do")
	public String addManager(Manager manager){
		CompanyManager cm = new CompanyManager();
		
		Integer managerId=managerMapper.findMaxManagerId();
		if(managerId==null){
			managerId=Integer.parseInt(read.readProperties("manager_id_min"));
		}
		manager.setManagerId(managerId+1);
		cm.setCompanyId(manager.getCompanyId());
		cm.setManagerId(manager.getManagerId());
		managerMapper.addManager(manager);
		managerMapper.addCompanyManager(cm);
		return "redirect:findSimpleManager.do";
	}
	@RequestMapping("/toModifyManager.do")
	public String toModifyManager(Model model,Integer managerId){
		List<Company> list = companyMapper.findSimpleCompany();
		List<CommonSubclass> practitioners = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("practitioners")));
		ManagerRelationVO manager = managerMapper.findManagerById(managerId);
		List<CommonSubclass> educations = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("education")));
		List<CommonSubclass> entirePeriod = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("entirePeriod")));
		model.addAttribute("companys", list);
		model.addAttribute("manager", manager);
		model.addAttribute("educations", educations);
		model.addAttribute("practitioners", practitioners);
		model.addAttribute("entirePeriod", entirePeriod);
		return "manager/manager";
	}
	@RequestMapping("/modifyManager.do")
	public String modifyManager(Manager manager){
		managerMapper.modifyManager(manager);
		return "redirect:findSimpleManager.do";
	}

}
