package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.quant.dao.CompanyMapper;
import com.quant.entity.City;
import com.quant.entity.Company;
import com.quant.entity.Province;
import com.quant.vo.PageVo;

@Controller
@RequestMapping("/operation/company")
public class CompanyController extends BaseController {
	@Resource
	private CompanyMapper companyMapper;
	
	@RequestMapping("/findAllCompany.do")
	public String findAll(){
		return "company/company_list";
	}
	@RequestMapping("/findSimpleCompany.do")
	public String finSimpleCompany(Model model,PageVo pageVo){
		Integer rows=companyMapper.findRows();
		pageVo.setRows(rows);
		List<Company> companys = companyMapper.findSimpleCompanyByPage(pageVo);
		model.addAttribute("companys", companys);
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("showPages", pageVo.getShowPages());
		return "company/company_list";
		
	}
	@RequestMapping("/toAddCompany.do")
	public String toAddCompany(Model model){
		List<Province> province = companyMapper.findAllProvince();
		model.addAttribute("province", province);
		
		return "company/add_company";
	}
	@RequestMapping("/addCompany.do")
	public String addCompany(Company company){
		Integer id = companyMapper.findMaxCompanyId();
		company.setCompanyId(id+1);
		companyMapper.addCompany(company);
		return "redirect:findSimpleCompany.do";
	}
	@RequestMapping("/toModifyCompany.do")
	public String toModifyCompany(Model model,Integer companyId){
		Company company = companyMapper.findCompanyById(companyId);
		Province province = companyMapper.findProvinceById(company.getProvince());
		City city = companyMapper.findCityById(company.getCity());
		List<Province> provinces = companyMapper.findAllProvince();
		List<City> citys = companyMapper.findCityByProvinceId(company.getProvince());
		model.addAttribute("company", company);
		model.addAttribute("province", province);
		model.addAttribute("city", city);
		model.addAttribute("provinces", provinces);
		model.addAttribute("citys", citys);
		return "company/company";
	}
	@RequestMapping("/modifyCompany.do")
	public String modifyCompany(Company company){
		if(company.getIsPartner()==null||company.getIsPartner().equals("")){
			company.setIsPartner(0);
		}
		companyMapper.modifyCompany(company);
		return "redirect:findSimpleCompany.do";
	}
	
	@ResponseBody
	@RequestMapping(value="/findCityByProvinceId.do",produces = "application/json")
	public List<City> findCityByProvinceId(City city){
		List<City> list = companyMapper.findCityByProvinceId(city.getProvinceId());
		return list;
	}

}
