package com.quant.controller;

import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.WebRequest;

import com.quant.util.DateEditor;
import com.quant.comm.ReadPro;
import com.quant.dao.TablefieldMapper;
import com.quant.entity.Tablefield;

public class BaseController extends JsonBaseController implements WebBindingInitializer{
	@Resource
	TablefieldMapper tablefieldMapper;
	
	private HashMap<Integer, String> tablefield;
	@Resource
	ReadPro read;
	@InitBinder
	public void initBinder(WebDataBinder binder, WebRequest request) {
		
		binder.registerCustomEditor(java.sql.Date.class, 
				new DateEditor()
		);
	}
	
	//快速通过分类表取得对应的字段数据，该方法只分执行一次数据库初始化动作。
	public String getTablefield(Integer key) {
		if (this.tablefield == null) {
			this.tablefield= new HashMap<Integer, String>();
			List<Tablefield> _list = tablefieldMapper.getTablefield();
			for (Tablefield _f: _list) {
				this.tablefield.put(_f.getKey(), _f.getValue());
			}
		}
		if (this.tablefield.containsKey(key)) {
			return tablefield.get(key);
		} else {
			return "N/A";
		}
	}
	
}
