package com.quant.controller;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.dao.AdminMapper;
import com.quant.dao.loginMapper;
import com.quant.entity.AdminstrationUser;
import com.quant.comm.LoginSecret;
import com.quant.comm.ReadPro;
import com.quant.comm.MD5;

@Controller
@RequestMapping("/operation/admin")
public class AdminController extends BaseController {

	@Resource
	private loginMapper loginMapper;

	@Resource
	private AdminMapper adminMapper;
	@Resource
	private ReadPro readPro;

	@RequestMapping("/findAdmin.do")
	public String findAll(Model model, HttpServletRequest request) {
		List<AdminstrationUser> list = adminMapper.findAll();
		model.addAttribute("list", list);
		return "index";
	}

	@RequestMapping("/loginCheck.do")
	public String getLogin(HttpServletRequest request,
			HttpServletResponse response,String loginName,String password,ModelMap map) {
		
		String extra = readPro.readProperties("password");
		String ids_ = LoginSecret.getCookie(request, response, "_ids");
		String tss_ = LoginSecret.getCookie(request, response, "_tss");
		String tokens = LoginSecret.getCookie(request, response, "tokens");
		boolean flag = LoginSecret.checkCookie(ids_, tss_, extra, tokens);
		if (flag) {
			return "index";
		}
		AdminstrationUser  admin = loginMapper.findByloginName(loginName);
		if ( admin == null) {
			return "admin/admin_error";
		}
		String dbPassword = admin.getPassword();

		String loginPassword = MD5.GetMD5Code( password + extra);

		if (loginPassword.equals(dbPassword)) {
			Integer id = admin.getId();
			Timestamp time = new Timestamp(System.currentTimeMillis());
			String token = MD5.GetMD5Code(id.toString() + "," + time.toString()
					+ "," + extra);
            Cookie names=new Cookie("name", loginName);
            names.setPath("/");
            response.addCookie(names);
			Cookie cs = new Cookie("tokens", token);
			cs.setPath("/");
			response.addCookie(cs);
			Cookie _tss = new Cookie("_tss", time.toString());
			_tss.setPath("/");
			response.addCookie(_tss);
			Cookie _ids = new Cookie("_ids", id.toString());
			_ids.setPath("/");
			response.addCookie(_ids);
			return "index";
		} else {
			return "admin/admin_error";
		}
	} 

	@RequestMapping("/addAdmin.do") 
	public String add(HttpServletRequest request, AdminstrationUser admin) {
		String extra = readPro.readProperties("password");
		admin.setStatus(0);
		admin.setAddTime(new Date(System.currentTimeMillis()));
		String password = admin.getPassword() + extra;
		admin.setPassword(MD5.GetMD5Code(password));
		AdminstrationUser user = adminMapper.findByLoginName(admin.getLoginName());
		if(user==null){
			adminMapper.add(admin);
			return "redirect:findAdmin.do";
		}else{
			return "admin/admin_addError";
		}
	}

	@RequestMapping("/changePassword.do")
	public String findById(HttpServletRequest request,HttpServletResponse response, String oldpassword,
			String newpassword) {
		String extra = readPro.readProperties("password");
		String _ids = LoginSecret.getCookie(request,response, "_ids");
		int id = Integer.parseInt(_ids);
		AdminstrationUser admin = adminMapper.findById(id);
		String dbPassword = admin.getPassword();
		String checkPassword = MD5.GetMD5Code(oldpassword + extra);
		if (dbPassword.equals(checkPassword)) {
			admin.setPassword(MD5.GetMD5Code(newpassword + extra));
			int i = adminMapper.updateById(admin);
			if (i > 0) {
				return "index";
			} else {
				return "admin/admin_error";
			}
		} else {
			return "admin/admin_error";
		}
	}

	@RequestMapping("/toAdd.do")
	public String toAdd(HttpServletRequest request) {
		return "admin/add_admin";
	}

	@RequestMapping("/toLoginCheck.do")
	public String toLoginCheck(HttpServletRequest request,ModelMap map) {
		return "admin/admin_login";
	}

	@RequestMapping("/toUpdate.do")
	public String toUpdate(HttpServletRequest request) {
		return "admin/admin_update";
	}
}