<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
<script src="/js/quant.js"></script>
	<style type="text/css">
			.current_page{border:solid 1px;padding:0 3px;}
	
	.all_user {
	font-size: 25px;
}

.not_verified {
	font-size: 25px;
}

.common_user {
	font-size: 25px;
}

.is_verified {
	font-size: 25px;
}
div.tabs
{
    width:940px;
	height:35px;
	overflow:hidden;
	padding-left:10px;
	margin-top:10px;
}
div.tabs ul li
{
	float:left;
	padding:0 5px;
}
div.tabs ul li a
{
	display:block;
	width:200px;
	height:36px;
	overflow:hidden;
	line-height:36px;
	text-align:center;
}
	</style>
	<script type="text/javascript">
			$(function(){
				var role="${userPageVo.role}";
				var isVerify="${userPageVo.isVerify}";
				$(".all_user").css({"fontSize":"20px","color":""});
				$(".not_verified").css({"fontSize":"20px","color":""});
				$(".common_user").css({"fontSize":"20px","color":""});
				$(".is_verified").css({"fontSize":"20px","color":""});
				if(role=='2'){
					$(".common_user").css({"fontSize":"25px","color":"#000"});
				}else if(role=='1'&&isVerify=='0'){
					$(".not_verified").css({"fontSize":"25px","color":"#000"});
				}else if(role=='1'&&isVerify=='1'){
					$(".is_verified").css({"fontSize":"25px","color":"#000"});
				}else{
					$(".all_user").css({"fontSize":"25px","color":"#000"});
				}
			});
	</script>
</head>
<body>
	<div class="container">
		<div class="navbar">
			<div class="navbar-inner">
				<%@include file="../navigation/menu.jsp"%>
			</div>
		</div>
		<div class="row">
			<%@include file="../navigation/navigation.jsp"%>
			<div class="span9">
				<div class="tabs">
					<ul>
						<li><a href="findUserByPage.do?role=2" ><span class="common_user">普通用户</span></a></li>
						<li><a href="findUserByPage.do?role=1&&isVerify=0" ><span class="not_verified">申请中的理财师</span></a> </li>
						<li><a href="findUserByPage.do?role=1&&isVerify=1" ><span class="is_verified">已认证的理财师</span></a></li>
						<li><a href="findUserByPage.do?role=&&isVerify=" > <span class="all_user">全部</span></a></li>
					</ul>
                
				</div>
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>姓名</th>
							<th>手机号码</th>
							<th>角色</th>
							<th>性别</th>
							<th>注册时间</th>
							<th>操作</th>
						</tr>
					</thead>
					<tbody>
						<c:forEach items="${users}" var="user">
							<tr>
								<td>${user.name }</td>
								<td>${user.mobile }</td>
								<td>
								<c:if test="${user.role==1}">
								<c:choose>
								<c:when test="${user.isVerify==1}">理财师(已认证)</c:when>
								<c:otherwise>理财师(未认证)</c:otherwise>
								</c:choose>
								</c:if>
								<c:if test="${user.role==2}">普通用户</c:if>
								</td>
								<td>
								<c:if test="${user.gender==1}">男</c:if>
								<c:if test="${user.gender==2}">女</c:if>
								<c:if test="${user.gender==0}">保密</c:if>
								</td>
								<td><fmt:formatDate value="${user.regDate}" pattern="yyyy-MM-dd HH:mm:ss"/></td>
								<td class="td_modi">
									<a href="toUpdateUser.do?uid=${user.uid}">编辑</a>&nbsp;&nbsp;
									<a href="javascript:;">查看</a>
								</td>
							</tr>
						</c:forEach>
						<tr>
						<td colspan="6">
						<c:if test="${userPageVo.currentPage<=1}">
	<a href="javascript:;">上一页</a>
</c:if>
<c:if test="${userPageVo.currentPage>1}">
	<a href="?currentPage=${userPageVo.currentPage-1}">上一页</a>
</c:if>

<c:forEach items="${userShowPages }" var="showPages">
	<c:choose>
		<c:when test="${showPages==userPageVo.currentPage }">
			<span class="current_page">${userPageVo.currentPage }</span>
		</c:when>
		<c:otherwise>
	        <a href="?currentPage=${showPages}">${showPages }</a>
		</c:otherwise>
	</c:choose>
</c:forEach>

<c:if test="${userPageVo.currentPage>=userPageVo.totalPage}">
	<a href="javascript:;">下一页</a>
</c:if>
<c:if test="${userPageVo.currentPage<userPageVo.totalPage}">
	<a href="?currentPage=${userPageVo.currentPage+1}">下一页</a>
</c:if>

<span>共${userPageVo.rows }条，共${userPageVo.totalPage }页</span>
						
						</td>
						</tr>
					</tbody>
				</table>
			
			</div>
		</div>
	</div>
</body>
</html>
