/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractSingleCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class CheckboxTag
extends AbstractSingleCheckedElementTag {
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        super.writeTagContent(tagWriter);
        if (!this.isDisabled()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            String name = "_" + this.getName();
            tagWriter.writeAttribute("name", name);
            tagWriter.writeAttribute("value", this.processFieldValue(name, "on", this.getInputType()));
            tagWriter.endTag();
        }
        return 0;
    }

    protected void writeTagDetails(TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("type", this.getInputType());
        Object boundValue = this.getBoundValue();
        Class<?> valueType = this.getBindStatus().getValueType();
        if (Boolean.class.equals(valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            this.renderFromBoolean(booleanValue, tagWriter);
        } else {
            Object value = this.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Attribute 'value' is required when binding to non-boolean values");
            }
            Object resolvedValue = value instanceof String ? this.evaluate("value", value) : value;
            this.renderFromValue(resolvedValue, tagWriter);
        }
    }

    protected String getInputType() {
        return "checkbox";
    }
}

