package com.quant.controller;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

import com.quant.comm.LoginSecret;
import com.quant.dao.OrderMapper;
import com.quant.dao.ProductMapper;
import com.quant.dao.WebsiteMapper;
import com.quant.entity.CommonSubclass;
import com.quant.entity.News;
import com.quant.entity.Order;
import com.quant.entity.ProductBasic;
import com.quant.vo.NewsPageVo;
import com.quant.vo.ProductRelationVO;
import com.quant.entity.ProductPerformance;
import com.quant.vo.ProductQueryVo;

@Controller
public class WebsiteController extends BaseController{
	@Resource
	private WebsiteMapper websiteMapper;
	@Resource
	private ProductMapper productMapper;
	@Resource
	private OrderMapper orderMapper;
	
	@RequestMapping("home/toWebsite.do")
	public String toWebsite(Model model){
		List<ProductRelationVO> newProduct = productMapper.findNewestProduct();
		for(ProductRelationVO p: newProduct) {
			p.setProductTypeName(this.getTablefield(p.getProductType()));
		}
		List<ProductRelationVO> classicProduct = productMapper.findClassicProduct();
		List<News> newsList1 = websiteMapper.findHotNews(1095);
		List<News> newsList2 = websiteMapper.findHotNews(1096);
		model.addAttribute("newProduct", newProduct);
		model.addAttribute("classicProduct", classicProduct);
		model.addAttribute("newsList1", newsList1);
		model.addAttribute("newsList2", newsList2);
		return "website/home_page";
	}
	

	@RequestMapping("/news/detail.do")
	public String toInformationNews(Model model,Integer newsId){
		News news = websiteMapper.getNewsByNewsId(newsId);
		List<CommonSubclass> subclass = websiteMapper.findCommonSubclassList(news.getNewsType());
		model.addAttribute("news", news);
		model.addAttribute("subclass", subclass);
		return "website/news/news_open_page";
	}
	@RequestMapping("/news/list.do")
	public String getNews(ModelMap map, Integer newsType, Integer pageindex) {
		if ( newsType == null) {
			newsType = 1105;
		}
		if(pageindex==null||pageindex==0){
			pageindex=1;
		}
		NewsPageVo pageVo = new NewsPageVo();
		pageVo.setCurrentPage(pageindex);
		pageVo.setNewsType(newsType);
		int rows = websiteMapper.findRowsByNewsType(newsType);
		pageVo.setRows(rows);
		List<CommonSubclass> subclass = websiteMapper.findCommonSubclassList(newsType);
		List<News> newsList = websiteMapper.findNewsList(pageVo) ;
		map.put("newsList", newsList);
		map.put("subclass", subclass);
		map.put("newsType", newsType);
		map.put("pageindex", pageindex);
		map.put("pageVo", pageVo);
		map.put("showPages", pageVo.getShowPages());
		if(newsType == 1023) {
			return "website/news/liststyle2";
		} else {
			return "website/news/list";
		}
	}
	
	@RequestMapping("/about/contact.do")
	public String aboutUS(ModelMap map, Integer id) {
		
		return "website/aboutus/contact_us";
	}
	
	@RequestMapping("/about/ceo.do")
	public String aboutCEO(ModelMap map, Integer id) {
		if ( id == null) {
			id = 1098;
		}
		News news = websiteMapper.getNewsByNewsType(id);
		map.put("news", news);
		return "website/aboutus/ceo";
	}
	@RequestMapping("/about/company.do")
	public String aboutCompany(ModelMap map, Integer id) {
		if ( id == null) {
			id = 1099;
		}
		News news = websiteMapper.getNewsByNewsType(id);
		map.put("news", news);
		return "website/aboutus/company";
	}
	
	@RequestMapping("/about/roadstone.do")
	public String aboutRoadStone(ModelMap map, Integer id) {
		if ( id == null) {
			id = 1100;
		}
		News news = websiteMapper.getNewsByNewsType(id);
		map.put("news", news);
		return "website/aboutus/roadstone";
	}
	
	@RequestMapping("/job/chance.do")
	public String aboutJob(ModelMap map, Integer id) {
		if ( id == null) {
			id = 1102;
		}
		List<News> newsList = websiteMapper.getJobNews(id);
		map.put("newsList", newsList);
		return "website/job/chance";
	}
	
	@RequestMapping("/product/classiccase.do")
	public String classicCase(ModelMap map, Integer id) {
		if ( id == null) {
			id = 1185;
		}
		News news = websiteMapper.getNewsByNewsId(id);
		map.put("news", news);
		return "website/product/classiccase";
	}
	
	/*产品相关功能增加，包括产品详情、产品声明、订购信息*/
	@RequestMapping("/product/detail.do")
	public String getProduct(ModelMap map, Integer productId, Integer typeId) {
		ProductRelationVO pb;
		if (productId == null) {
			pb = productMapper.findLastProductByCompanyId(1002);
		} else {
			pb = productMapper.findProductByProductId(productId);
		}

		if ( pb != null) {
			typeId = pb.getProductType();
			productId = pb.getProductId();
		}
		//目前只有两个类型有产品，其它的都是空的
		List<ProductBasic>  list1090 = productMapper.findProductByProductType(1090);//定增基金
		List<ProductBasic>  list1091 = productMapper.findProductByProductType(1091);//对冲基金母基金
		//List<ProductBasic>  listhot = productMapper.findHotfundsByCompanyId(1002);//公司的热销产品，募集期的产品
		//map.put("listhot", listhot);
		map.put("list1090", list1090);
		map.put("list1091", list1091);
		map.put("currentProduct", pb);
		map.put("typeId", typeId);
		map.put("productId", productId);
		return "website/product/detail";
	}
	
	/*产品相关功能增加，包括产品详情、产品声明、订购信息*/
	@RequestMapping("/product/hotfunds.do")
	public String getHotfunds(ModelMap map, Integer productId) {
		Integer typeId = 0;
		ProductRelationVO pb = null;
		if (productId != null) {
			pb = productMapper.findHotfundsByProductId(productId);
		} else {
			pb = productMapper.findLastHotfundstByCompanyId(1002);
			if (pb != null) {
				productId = pb.getProductId();
			}
		}
		//目前只有两个类型有产品，其它的都是空的
		//List<ProductBasic>  list1090 = productMapper.findProductByProductType(1090);//定增基金
		//List<ProductBasic>  list1091 = productMapper.findProductByProductType(1091);//对冲基金母基金
		List<ProductBasic>  listhot = productMapper.findHotfundsByCompanyId(1002);//公司的热销产品，募集期的产品
		map.put("listhot", listhot);
		//map.put("list1090", list1090);
		//map.put("list1091", list1091);
		map.put("productId", productId);
		map.put("currentProduct", pb);
		map.put("typeId", typeId);
		
		return "website/product/hotfunds";
	}
	
	@RequestMapping("/product/statement.do")
	public String getStatement(HttpServletRequest request,
			HttpServletResponse response, ModelMap map, Integer productId, Integer status) {
		if (LoginSecret.getCookie(request, response, "_readStatement").length() > 3 && productId != null)
		{
			if (status != null && status == 1) {
				return "redirect:/product/hotfunds.do?productId=" + productId;
			} else {
				return "redirect:/product/detail.do?productId=" + productId;
			}
		} else {
			
			Cookie c = new Cookie("_readStatement", "true");
			c.setPath("/");
			response.addCookie(c);
			map.put("productId", productId);
			map.put("status", status);
			return "website/product/statement_page";
		}
	}
	
	@RequestMapping("/product/order.do")
	public String getStatement(ModelMap map, Integer productId) {
		List<ProductBasic>  productList = productMapper.findProductByCompanyId(1002);
		ProductRelationVO pb;
		if (productId == null) {
			pb = productMapper.findLastProductByCompanyId(1002);
		} else {
			pb = productMapper.findProductByProductId(productId);
		}
		//目前只有两个类型有产品，其它的都是空的
		
		map.put("currentProduct", pb);
		map.put("productList", productList);
		map.put("productId", productId);
		return "website/product/product_reservation";
	}
	@RequestMapping("/product/order_submit.do")
	public void orderSubmit(HttpServletResponse response, Integer productId, String mobile, Integer orderMount, String userName)
	{
		Integer maxId = orderMapper.findMaxId();
		Order order = new Order();
		order.setUid(0);
		order.setOrderId(maxId + 1);
		DateFormat fmt = new SimpleDateFormat("yyyyMMdd"); 
		String orderCode = String.format("%s%08d", fmt.format(new java.util.Date()), maxId+1);
		order.setOrderCode(orderCode);
		order.setUserName(userName);
		order.setMobile(mobile);
		order.setOrderMount(orderMount);
		order.setOrgin(3);
		order.setProductId(productId);
		order.setIntroducerUid(0);
		order.setDescription("无");
		
		response.setHeader("Content-type", "text/html;charset=UTF-8");
		if (orderMapper.addUserOrder(order) == 1) {
			try {
				response.getWriter().write("<html><body><script language=\"javascript\">alert(\"预约成功，我们的工作人员会在1个工作日内与您取得联系！\");window.location=\"/product/detail.do\";</script></body></html>");
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else {
		try {
			response.getWriter().write("<html><body><script language=\"javascript\">alert(\"对不起，预约失败，请稍候重试！\");window.location=\"/product/detail.do\";</script></body></html>");
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	@RequestMapping("/product/mafunds.do")
	public String getMAFunds(ModelMap map, Integer productId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		return "website/product/mafunds";
	}
	@RequestMapping("/product/angelsfunds.do")
	public String getAngelsFunds(ModelMap map, Integer productId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		return "website/product/angelsfunds";
	}
	@RequestMapping("/product/new3board.do")
	public String getNew3Board(ModelMap map, Integer productId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		return "website/product/new3board";
	}
	
	@RequestMapping("/product/pipe.do")
	public String getPIPE(ModelMap map, Integer productId, Integer typeId) {
		//目前只有两个类型有产品，其它的都是空的
		List<ProductBasic>  list1090 = productMapper.findProductByProductType(1090);//定增基金
		List<ProductBasic>  list1091 = productMapper.findProductByProductType(1091);//对冲基金母基金
		//List<ProductBasic>  listhot = productMapper.findHotfundsByCompanyId(1002);//公司的热销产品，募集期的产品
		//map.put("listhot", listhot);
		map.put("list1090", list1090);
		map.put("list1091", list1091);
		map.put("productId", productId);
		map.put("typeId", typeId);
		return "website/product/pipe";
	}
	
	@RequestMapping("/product/hfmf.do")
	public String getHFMF(ModelMap map, Integer productId, Integer typeId) {
		//目前只有两个类型有产品，其它的都是空的
		List<ProductBasic>  list1090 = productMapper.findProductByProductType(1090);//定增基金
		List<ProductBasic>  list1091 = productMapper.findProductByProductType(1091);//对冲基金母基金
		//List<ProductBasic>  listhot = productMapper.findHotfundsByCompanyId(1002);//公司的热销产品，募集期的产品
		//map.put("listhot", listhot);
		map.put("list1090", list1090);
		map.put("list1091", list1091);
		map.put("productId", productId);
		map.put("typeId", typeId);
		return "website/product/hfmf";
	}
	
	@RequestMapping("/product/eventdriven.do")
	public String getEventDriven(ModelMap map, Integer productId, Integer typeId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		map.put("typeId", typeId);
		return "website/product/eventdriven";
	}
	
	@RequestMapping("/product/question.do")
	public String getQuestion(ModelMap map, Integer productId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		return "website/product/question";
	}
	
	@RequestMapping("/product/orderstep.do")
	public String getOrderstep(ModelMap map, Integer productId) {
		//目前只有两个类型有产品，其它的都是空的
		map.put("productId", productId);
		return "website/product/orderstep";
	}
	/**
	 * 查看基金表现
	 * 基金净值历史数据
	 */
	@SuppressWarnings({ "rawtypes", "unchecked", "unused" })
	@RequestMapping("/product/performance.do")
	public void getProductPerformance(HttpServletRequest request,HttpServletResponse response,
			Integer productId, Integer last, Integer hs){
		ProductQueryVo vo = new ProductQueryVo();
		vo.setLast(last);
		vo.setHs(hs);
		vo.setProductId(productId);
		List<ProductPerformance> list = productMapper.getProductPerformance(vo);
		List<ProductPerformance> _tmp = productMapper.getHSPerformance(list.get(0).getExpiryDate());
		List<ProductPerformance> hsList = com.quant.comm.FundsPerformance.getHS300(_tmp, list);
		HashMap<String, Object> map= new HashMap<String,Object>();
		List pdata = new ArrayList();
		List hsdata = new ArrayList();
		if(list!=null){
			for(ProductPerformance p:list){
				List l = new ArrayList();
				if(p.getExpiryDate()==null){
					p.setExpiryDate(new Date());
				}
				l.add(p.getExpiryDate().getTime());
				l.add(p.getNetValue());
				pdata.add(l);
			}
			map.put("pdata", pdata);
		}else{
			map.put("pdata", null);
		}
		if(hsList!=null){
			for(ProductPerformance p:hsList){
				List l = new ArrayList();
				if(p.getExpiryDate()==null){
					p.setExpiryDate(new Date());
				}
				l.add(p.getExpiryDate().getTime());
				l.add(p.getNetValue());
				hsdata.add(l);
			}
			map.put("hsdata", hsdata);
		}else{
			map.put("hsdata", null);
		}
		JsonEntity json = this.getJsonInstance();
		json.setData(map);
		json.flush(response);
	}

}
