<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
<script src="/js/quant.js"></script>
	<style type="text/css">
		.current_page{border:solid 1px;padding:0 3px;}
	</style>
</head>
<body>
	<div class="container">
		<div class="navbar">
			<div class="navbar-inner">
				<%@include file="../navigation/menu.jsp"%>
			</div>
		</div>
		<div class="row">
			<%@include file="../navigation/navigation.jsp"%>
			<div class="span9">
				<h1>用户收藏</h1>
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>标题</th>
							<th>描述</th>
							<th>类型</th>
							<th>收藏时间</th>
							<th>收藏人</th>
						</tr>
					</thead>
					<tbody>
						<c:forEach items="${favorite}" var="favorite">
							<tr>
								<td>${favorite.title }</td>
								<td>${favorite.description }</td>
								<td>
									<c:if test="${favorite.favoriteType==1}">新闻类</c:if>
									<c:if test="${favorite.favoriteType==2}">产品类</c:if>
									<c:if test="${favorite.favoriteType==3}">会议类</c:if>
								</td>
								<td><fmt:formatDate value="${favorite.pubTime}" pattern="yyyy-MM-dd"/></td>
								<td>${favorite.uname }</td>
							</tr>
						</c:forEach>
						<tr>
						<td colspan="5">
						<%@include file="../navigation/page.jsp"%>
						</td>
						</tr>
					</tbody>
				</table>
			
			</div>
		</div>
	</div>
</body>
</html>
