<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> 
<html>
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<script src="/js/html5.js"></script>
		<script type="" src="/js/ajaxfileupload.js"></script>
		<script type="text/javascript">
		function deleteAttachment(id){
			var r = window.confirm("确定要删除此附件吗?");
			if(r){
				location.href="deleteAttachment.do?id="+id;
			}
		}
		</script>
		<style type="text/css">
		.current_page{border:solid 1px;padding:0 3px;}
	</style>
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp" %>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp" %>
				<div class="span9">
					<h1>
						附件列表
					</h1>
					<table class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>
									附件名
								</th>
								<th>
									附件类型
								</th>
								<th>
									上传时间
								</th>
								<th>
								  文件链接
								</th>
								<th>
									操作
								</th>
								
							</tr>
						</thead>
						<tbody>
						<c:forEach items="${attachment}" var="attachment">
							<tr>
								<td>
									${attachment.title }
								</td>
								<td>
									${attachment.attachmentType }
								</td>
								<td>
									<fmt:formatDate pattern="yyyy-MM-dd HH:mm:ss" value="${attachment.postTime}"></fmt:formatDate>
								</td>
								<td>
								    <c:if test="${attachment.attachmentType==2}">/${attachment.uri}</c:if>
								    <c:if test="${attachment.attachmentType!=2}">${attachment.uri}</c:if>
								</td>
								<td>
									<input type="button" value="删除" onclick="deleteAttachment(${attachment.id});"/>
									<input type="button" value="修改" onclick="location.href='toUpdateAttachment.do?id=${attachment.id}'"/>
								    <a href="download.do?attachmentId=${attachment.id}">下载</a>
								</td>
							</tr>
							</c:forEach>
							<tr>
							<td colspan="4">
						<%@include file="../navigation/page.jsp"%>
						</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</body>
</html>
