package com.quant.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.quant.comm.ReadPro;
import com.quant.dao.CompanyMapper;
import com.quant.dao.ManagerMapper;
import com.quant.dao.ProductMapper;
import com.quant.dao.ProductTypeMapper;
import com.quant.dao.SettingMapper;
import com.quant.entity.Attachment;
import com.quant.entity.CommonSubclass;
import com.quant.entity.Company;
import com.quant.entity.ProductBasic;
import com.quant.entity.ProductCommission;
import com.quant.entity.ProductDescription;
import com.quant.vo.ManagerRelationVO;
import com.quant.vo.ProductPageVo;
import com.quant.vo.ProductRelationVO;

@Controller
@RequestMapping("/operation/product")
public class ProductController extends BaseController {
	@Resource
	private ProductMapper productMapper;
	@Resource
	private CompanyMapper companyMapper;
	@Resource
	private ManagerMapper managerMapper;
	@Resource
	private ProductTypeMapper productTypeMapper;
	@Resource
	private SettingMapper settingMapper;
	@Resource
	private ReadPro readPro;
	
	@RequestMapping("/findAllProduct.do")
	public String findAll(){
		return "product/product_list";
	}
	@RequestMapping("/findSimpleProduct.do")
	public String findSimpleProduct(Model model,ProductPageVo pageVo){
		Integer rows=productMapper.findRows(pageVo);
		pageVo.setRows(rows);
		List<ProductBasic> products = productMapper.findSimpleProductByPage(pageVo);
		model.addAttribute("products", products);
		model.addAttribute("pageVo", pageVo);
		model.addAttribute("status", pageVo.getStatus());
		model.addAttribute("showPages", pageVo.getShowPages());
		return "product/product_list";
	}
	@RequestMapping("/toAddProduct.do")
	
	public String toAddProduct(Model model){
		List<Company> companys = companyMapper.findSimpleCompany();
		List<CommonSubclass> productTypes = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("productType")));
		List<CommonSubclass> issuePortal = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("issuePortal")));
		List<CommonSubclass> duration = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("duration")));
		List<CommonSubclass> closedPeriod = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("closedPeriod")));
		List<CommonSubclass> investmentRegion = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("investmentRegion")));
		List<CommonSubclass> investorScope = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("investorScope")));
		List<CommonSubclass> majorStrategy = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("majorStrategy")));
		List<CommonSubclass> mihf = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("mihf")));
		List<CommonSubclass> currencyType = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("currencyType")));
		List<CommonSubclass> supervisionUnits = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("supervisionUnits")));
		model.addAttribute("companys", companys);
		model.addAttribute("productTypes", productTypes);
		
		model.addAttribute("issuePortal", issuePortal);
		model.addAttribute("duration", duration);
		model.addAttribute("closedPeriod", closedPeriod);
		model.addAttribute("investmentRegion", investmentRegion);
		model.addAttribute("investorScope", investorScope);
		model.addAttribute("majorStrategy", majorStrategy);
		model.addAttribute("mihf", mihf);
		model.addAttribute("currencyType", currencyType);
		model.addAttribute("supervisionUnits", supervisionUnits);
		
		
		return "product/add_product";
	}
	
	@RequestMapping("/addProduct.do")
	public String addProduct(ProductRelationVO product,HttpServletRequest request){
		if(product.getExpectedProfit()==null){
			product.setExpectedProfit(0);
		}
		if(product.getShowStatus()==null){
			product.setShowStatus(0);
		}
		product.setExpectedProfit(product.getExpectedProfit()*1000);
		productMapper.addProductBasic(product);
		product.setProductId(product.getId());
		productMapper.modifyProductBasic(product);
		return "redirect:findSimpleProduct.do";
	}
	
	@RequestMapping("/toModifyProduct.do")
	public String toModifyProduct(Model model,Integer productId){
		List<Company> companys = companyMapper.findSimpleCompany();
		List<ManagerRelationVO> managers = managerMapper.findSimpleManager();
		List<CommonSubclass> productTypes = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("productType")));
		
		List<CommonSubclass> issuePortals = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("issuePortal")));
		List<CommonSubclass> durations = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("duration")));
		List<CommonSubclass> closedPeriods = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("closedPeriod")));
		List<CommonSubclass> investmentRegions = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("investmentRegion")));
		List<CommonSubclass> investorScopes = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("investorScope")));
		List<CommonSubclass> majorStrategys = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("majorStrategy")));
		List<CommonSubclass> mihfs = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("mihf")));
		List<CommonSubclass> currencyTypes = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("currencyType")));
		List<CommonSubclass> supervisionUnits = settingMapper.findCommonSubclassByCategoryId(Integer.parseInt(readPro.readProperties("supervisionUnits")));
		
		ProductRelationVO product = productMapper.findProductById(productId);
		
		if(product != null && product.getMajorStrategy()!=null){
			CommonSubclass majorStrategy = settingMapper.findCommonSubclassBySubclassId(product.getMajorStrategy());
			model.addAttribute("majorStrategy", majorStrategy);
			List<CommonSubclass> minorStrategys = settingMapper.findCommonSubclassByPid(product.getMajorStrategy());
			model.addAttribute("minorStrategys", minorStrategys);
		}

		
		model.addAttribute("companys", companys);
		model.addAttribute("managers", managers);
		model.addAttribute("productTypes", productTypes);
		
		model.addAttribute("issuePortals", issuePortals);
		model.addAttribute("durations", durations);
		model.addAttribute("closedPeriods", closedPeriods);
		model.addAttribute("investmentRegions", investmentRegions);
		model.addAttribute("investorScopes", investorScopes);
		model.addAttribute("majorStrategys", majorStrategys);
		model.addAttribute("mihfs", mihfs);
		model.addAttribute("currencyTypes", currencyTypes);
		model.addAttribute("supervisionUnits", supervisionUnits);
		if(product.getExpectedProfit()==null){
			product.setExpectedProfit(0);
		}else{
			product.setExpectedProfit(product.getExpectedProfit()/1000);
		}
		
		model.addAttribute("product", product);
		
		
		
		return "product/product";
	}
	@RequestMapping("/modifyProduct.do")
	public String modifyProduct(Integer expectedProfit,ProductRelationVO product,HttpServletRequest request,Integer status){
		product.setId(product.getProductId());
		ProductRelationVO _sub = productMapper.getProductSubscribe(product.getProductId());
		ProductRelationVO _iss = productMapper.getProductIssue(product.getProductId());
		productMapper.modifyProductBasic(product);
		if (_sub != null && _sub.getProductId() > 0) {
			productMapper.modifyProductSubscribe(product);
		} else {
			productMapper.addProductSubscribe(product);
		}
		
		if (_iss != null && _iss.getProductId() > 0) {
			productMapper.modifyProductIssue(product);
		} else {
			productMapper.addProductIssue(product);
		}
		
		if(product.getShowStatus()==null){
			product.setShowStatus(0);
		}
		//截止日期不为空，更新产品业绩表现
		if(product.getExpiryDate()!=null){
			ProductRelationVO p = productMapper.findProductPerformanceByExpiryDate(product);
			if(p!=null){	
				productMapper.modifyProductPerformance(product);
			}else{
				productMapper.addProductPerformance(product);
			}
		}
		ProductRelationVO pv = productMapper.findProductByProductId(product.getProductId());
		if(pv.getShowStatus()==null){
			pv.setShowStatus(0);
			productMapper.modifyProductBasic(pv);
		}
		return "redirect:findSimpleProduct.do";
	}
	
	@RequestMapping(value="findMinorStrategyByMajorStrategyId.do",produces = "application/json")
	@ResponseBody
	public List<CommonSubclass> findMinorStrategyByMajorStrategyId(Integer majorStrategyId){
		List<CommonSubclass> list = settingMapper.findCommonSubclassByPid(majorStrategyId);
		return list;
	}
	@RequestMapping(value="findManagerByCompany.do",produces = "application/json")
	@ResponseBody
	public List<ManagerRelationVO> findManagerByCompany(Integer companyId){
		List<ManagerRelationVO> managers = managerMapper.findManagerByCompany(companyId);
		return managers;
	}
	@RequestMapping(value="findProductPerformanceByExpiryDate.do",produces = "application/json")
	@ResponseBody
	public ProductRelationVO findProductPerformanceByExpiryDate(ProductRelationVO p){
		ProductRelationVO product = productMapper.findProductPerformanceByExpiryDate(p);
		return product;
	}
	@RequestMapping("/findProductPerformance.do")
	public String findProductPerformance(Model model,ProductRelationVO p){
		List<ProductRelationVO> products = productMapper.findProductPerformance(p.getProductId());
		ProductRelationVO product = productMapper.findProductPerformanceByExpiryDate(p);
		model.addAttribute("products", products);
		model.addAttribute("product", product);
		return "product/look_product_performance";
	}
	
	
	
	@RequestMapping("/toProductCommission.do")
	public String toProductCommission(Model model,Integer productId){
		List<ProductCommission> commissions = productMapper.findProductCommission(productId);
		model.addAttribute("commissions", commissions);
		model.addAttribute("productId", productId);
		return "product/product_commission";
	}
	@RequestMapping("/toProductDescription.do")
	public String toProductDescription(Model model,Integer productId){
		ProductDescription description = productMapper.findProductDescriptionByProductId(productId);
		model.addAttribute("productId", productId);
		model.addAttribute("description", description);
		return "product/product_description";
	}
	
	@RequestMapping("/toProductAttachment.do")
	public String toAttachment(Model model,Integer relationId,Integer attachmentType){
		if(attachmentType==null||attachmentType.equals("")||attachmentType==2){
			List<Attachment> attachment = productMapper.findAttachmentByRelationId(relationId);
			model.addAttribute("attachment", attachment);
			model.addAttribute("relationId", relationId);
			return "product/product_attachment";
		}
		return "product/product_attachment";
	}

	@RequestMapping("/uplodeAttachment.do")
	@ResponseBody
	public String addAttachment(Attachment attachment){
		attachment.setAttachmentType(2);
		Integer size = attachment.getSize();
		size = size/1024;
		attachment.setSize(size);
		productMapper.addAttachment(attachment);
		return "200";
	}
	
	@RequestMapping("/deleteAttachment.do")
	public String deleteAttachment(Integer id){
		Integer relationId = productMapper.findRelationIdById(id);
		productMapper.deleteAttachmentById(id);
		return "redirect:toProductAttachment.do?relationId="+relationId;
	}
	
	@RequestMapping("/addOrModifyProductCommission.do")
	public String addOrModifyProductCommission(ProductCommission commission,Integer flag){
		if(flag==0){
			Integer sortId = productMapper.findMaxSortIdByProductId();
			if(sortId==null){
				commission.setSortId(1);
			}else{
				commission.setSortId(sortId+1);
			}
			productMapper.addProductCommission(commission);
		}else{
			commission.setId(flag);
			productMapper.modifyProductCommission(commission);
		}
		return "redirect:"+"toProductCommission.do?productId="+commission.getProductId();
	}
	
	@RequestMapping("/addOrModifyProductDescription.do")
	public String addOrModifyProductDescription(ProductDescription description,String[] editorValue){
		//此处有风险，顺序一调保存的值全错了
		description.setMihfInfo(editorValue[0]);
		description.setRoadshowInfo(editorValue[1]);
		description.setSubscribeInfo(editorValue[2]);
		description.setTeamInfo(editorValue[3]);
		description.setRiskInfo(editorValue[4]);
		
		ProductDescription productDescription = productMapper.findProductDescriptionByProductId(description.getProductId());
		if(productDescription==null){			
			productMapper.addProductDescription(description);
		}else{
			productMapper.modifyProductDescription(description);
		}
		return "redirect:toModifyProduct.do?productId="+description.getProductId();
	}
	
	@RequestMapping(value="/findProductCommissionByAmount.do",produces="application/json")
	@ResponseBody
	public ProductCommission findProductCommissionByAmount(ProductCommission productCommission){
		ProductCommission commission = productMapper.findProductCommissionByAmount(productCommission);
		return commission;
	}
	@RequestMapping(value="/deleteProductCommission.do",produces="application/json")
	@ResponseBody
	public int deleteProductCommission(int id){
		int data = productMapper.deleteProductCommission(id);
		return data;
	}
		
	@RequestMapping(value="/modifySort.do",produces="application/json")
	@ResponseBody
	public int modifySortId(ProductBasic productBasic){
		if(productMapper.modifySort(productBasic)==1){
			return 1;
		}else{
			return 0;
		}
	}

}
