package com.quant.comm;

import java.io.IOException;
import java.util.Properties;

import javax.annotation.PostConstruct;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Component;

@Component
public class ReadPro {
	private Properties properties;
	
	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	@PostConstruct
	public void loadProperties() throws IOException {
		properties = new Properties();
		Resource resource = new ClassPathResource("config.properties");
		properties = PropertiesLoaderUtils.loadProperties(resource);

	}

	public String readProperties(String temp) {
		return properties.getProperty(temp);
	}
	
}
