<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]--><!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]--><!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]--><!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]--><!--[if (gt IE 9)|!(IE)]><!--> 
<html lang="en"><!--<![endif]--> 
	<head>
		<meta charset="utf-8">
		<title>宽客财富</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link type="text/css" href="../css/bootstrap.min.css" rel="stylesheet">
		<link type="text/css" href="../css/bootstrap-responsive.min.css" rel="stylesheet">
		<link type="text/css" href="../css/site.css" rel="stylesheet">
		<script type="text/javascript" src="../js/jquery-1.11.2.js"></script>
		 <script language="javascript" type="text/javascript">
		 	function check_loginName(){
		 		var loginName = $("#loginName").val();
		 		if(loginName==""){
		 			$("#loginName_msg").text("用户名不能为空");
		 			return;
		 		}
		 		var reg =/^[a-zA-Z][a-zA-Z0-9_]{4,15}$/;
		 		if(!reg.test(loginName)){
		 			$("#loginName_msg").text("用户名格式不正确");
		 			return;
		 		}
		 		$("#loginName_msg").text("有效的用户名");
		 	}
		 

			function check_password(){
		 		var password = $("#password").val();
		 		if(password==""){
		 			$("#password_msg").text("密码不能为空");
		 			return;
		 		}
		 		var reg =/^[a-zA-Z]\w{5,17}$/;
		 		if(!reg.test(password)){
		 			$("#password_msg").text("密码格式不正确");
		 			return;
		 		}
		 		$("#password_msg").text("有效的密码");
		 	}
		 </script>
		<!--[if lt IE 9]><script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script><![endif]-->
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp"%>
				</div>
			</div>
			<div class="row">
					<%@include file="../navigation/navigation.jsp"%>
				<div class="span9">
					<h1>
						管理你的账户
					</h1>
					<form action="addUser.do"  method="post" id="edit-profile" class="form-horizontal">
						<fieldset>
							<legend>你的账户</legend>
							
							<div class="control-group">
								<label class="control-label" for="loginName">用户名</label>
								<div class="controls">
									<input type="text"  id="loginName" name="loginName" onblur="check_loginName();"/>
									<div class="validate_msg_long" id="loginName_msg">字母开头，允许5-16字节，允许字母数字下划线</div>
								</div>
							</div>
							
							<div class="control-group">
								<label class="control-label" for="password">密码</label>
								<div class="controls">
									<input type="password"  id="password" name="password" onblur="check_password();" />
									<div  class="password_msg_long" id="password_msg">以字母开头，长度在6~18之间，只能包含字母、数字和下划线</div>
								</div>
							</div>
							
							<div class="control-group">
								<label class="control-label" for="realName">真实姓名</label>
								<div class="controls">
									<input type="text" id="realName" name="realName"  />
								</div>
							</div>
							
							<div class="control-group">
								<label class="control-label" for="fileInput">照片</label>
								<div class="controls">
									<input class="input-file" id="fileInput" type="file" />
								</div>
							</div>						
										
							<div class="form-actions">
								<input type="submit" value="确认" class="btn_save" />
								<input type="button" value="退出" class="btn" onclick="history.back();" />
							</div>
						</fieldset>
					</form>
				</div>
			</div>
		</div>
		<script src="js/site.js"></script>
	</body>
</html>
