<%@page pageEncoding="utf-8" contentType="text/html; charset=utf-8" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<!--[if lt IE 7 ]><html lang="en" class="ie6 ielt7 ielt8 ielt9"><![endif]--><!--[if IE 7 ]><html lang="en" class="ie7 ielt8 ielt9"><![endif]--><!--[if IE 8 ]><html lang="en" class="ie8 ielt9"><![endif]--><!--[if IE 9 ]><html lang="en" class="ie9"> <![endif]--><!--[if (gt IE 9)|!(IE)]><!--> 
<html lang="en"><!--<![endif]--> 
	<head>
		<%@include file="/WEB-INF/navigation/JsAndCss.jsp" %>
		<style type="text/css">
		.current_page{border:solid 1px;padding:0 3px;}
		</style>
		
	</head>
	<body>
		<div class="container">
			<div class="navbar">
				<div class="navbar-inner">
					<%@include file="../navigation/menu.jsp"%>
				</div>
			</div>
			<div class="row">
				<%@include file="../navigation/navigation.jsp"%>
				
				<div class="span9">
					<h1>
						分类管理
					</h1>
					<table class="table table-bordered table-striped">
						<thead>
							<tr>
								<th>
									ID
								</th>
								<th>
									类别名称
								</th>
								<th>
									类别描述
								</th>
								<th>
									操作
								</th>
							</tr>
						</thead>
						<tbody>
							<c:forEach items="${category}" var="c">
							<tr>
								<td>
									${c.categoryId}
								</td>
								<td>
									${c.title}
								</td>
								<td>
									${c.description}
								</td>
								<td>
								    <a href="toUpdateCategory.do?categoryId=${c.categoryId}">编辑</a>&nbsp;&nbsp;
								    <a href="findSubclass.do?categoryId=${c.categoryId}">查看</a>
								</td>
							</tr>
							</c:forEach>
							<tr>
							<td colspan="4">
							<%@include file="../navigation/page.jsp"%>
							</td>
							</tr>
							<tr>
							<td colspan="4"><input type="button" value="新增分类" onclick="location.href='toAddCategory.do'"/></td>
							</tr>
						</tbody>
					</table>
					
				</div>
			</div>
		</div>
	</body>
</html>