// import "babel-polyfill";

function fetch(query, panel) {
    const data = {...query, p: (parseInt(query.p, 10) || 1) - 1};

    request('/api/1.0/prod/hList.json', data).done(({hasNext, items})=> {
        if (items && items.length) {
            let html = items.map(item=> {
                return `<li data-id="${item.id}" class="product-item status-${item.status}">
                <i class="seal">${
                    (item.status == 11 && (item.fundRaisedTarget - item.fundRaisedOver > 0)) ?
                    '<span>' + formatMoney(item.fundRaisedTarget - item.fundRaisedOver) + '</span>' : ''
                    }</i>
                <div class="clear main">
                    <div class="main-left">
                        <h2>${item.itemShortTitle}</h2>
                        <h3>${formatMoney(item.fundRaisedTarget)}</h3>
                        <div class="clear">
                            <span class="main-left-01">
                                <p>${item.productProspectiveReturn || '&nbsp;'}</p>
                            </span>
                            <span class="main-left-02">
                                <p>${formatMoney(item.minimumAmount)}</p>
                            </span>
                            <span class="main-left-03">
                                <p>${item.duration}</p>
                            </span>
                        </div>
                    </div>
                    <div class="main-right">
                        <div>
                            <h4>项目亮点</h4>
                            <p>${item.summary}</p>
                        </div>
                    </div>
                </div>
                <i class="corner"></i>
            </li>`;
            }).join('');
            $('.products', panel).html(html);
            const pagination = [];
            if (hasNext) {
                pagination.push(`<a data-cate-id="${data.cateId}" data-p="${data.p + 2}" data-s="${data.s}" href="javascript:void('下一页');">下一页</a>`);
            }

            if (data.p >= 1) {
                pagination.unshift(`<a data-cate-id="${data.cateId}" data-p="${data.p}" data-s="${data.s}" href="javascript:void('上一页');">上一页</a>`);
            }
            $('.pagination', panel).html(pagination.join(''));
            history.replaceState && history.replaceState(null, null, location.pathname + '?' + serialize(query));
        }
    }).fail(err=> {
        console.log(err);
    });
}


function fetchCates(query) {
    request('/api/1.0/cate/cates.json').done(({pCates})=> {
        const cates = [];
        pCates.unshift({
            name: '全部',
            id: 'all'
        });
        pCates.forEach(cate=> {
            !cate.selfPick && cates.push(cate.name);
        });
        const tabs = new Tabs({
            container: '.tabs',
            headers: cates,
            initializePanel: function (index, header, panel) {
                let cate = pCates[index];
                let fetchQuery = cate.id == query.cateId ? query : {cateId: cate.id, p: 1, s: query.s || 10};
                panel.html('<ul class="products"><li class="loading">正在努力加载中...</li></ul><ul class="pagination"></ul>');
                fetch(fetchQuery, panel);
            }
        });
        tabs.initialize();
        tabs.element.on('click', '.pagination a', function (e) {
            e.preventDefault();
            const data = $(this).data();
            fetch(data, tabs.findPanel(tabs.activeIndex));
            $(this).text('加载中...')
        }).on('click', '.product-item', function (e) {
            e.preventDefault();
            const id = $(this).data('id');
            location.href = location.pathname + '/' + id;
        })
    });
}

fetchCates(deserialize());
