/**
 * Created by Administrator on 2016/7/27.
 */
(function () {
    var $submit = $('#submit');
    var $errorPhone = $('.error-phone');
    var $errorDescription = $('.error-description');
    var $introducerMobile = $('#introducerMobile');
    var $projectDescription = $('#projectDescription');
    var $modalBox = $('.modal_box');

    /**
     * 验证手机号
     * @param tel
     * @returns {boolean}
     */
    function valiTel(tel) {
        var msg = /^[\d]{11}$/.test(tel) ? '' : '电话号码有误，请再次输入！';
        $errorPhone.html(msg);
        !msg && disableSubmit();
        return !msg;
    }

    /**
     * 验证项目描述不能为空
     * @param text
     * @returns {boolean}
     */
    function valiDescription(text) {
        $errorDescription.html(text ? '' : '项目描述不能为空!');
        text && disableSubmit();
        return !text;
    }

    /**
     * 提交按钮是否可用
     */
    function disableSubmit() {
        $submit.attr('disabled') && $submit.attr('disabled', false).css('background', '#ff4a4b');
    }

    $introducerMobile.on({
        keyup: function (e) {
            valiTel(($introducerMobile.val() + '').trim());
        }
    })
    $projectDescription.on({
        keyup: function (e) {
            valiDescription(($projectDescription.val() + '').trim());
        }
    });

    $('#introducer').on('submit', function (e) {
        if (valiTel(($introducerMobile.val() + '').trim())) {
            $introducerMobile.focus();
            e.preventDefault();
            return;
        }
        if (valiDescription(($projectDescription.val() + '').trim())) {
            $projectDescription.focus();
            e.preventDefault();
            return;
        }
    });


    /**
     * 地图项目地址弹框
     */
    $('.project_one').click(function (e) {
        e.preventDefault();
        $modalBox.show();
    });
    $('#modal_box_hidden').click(function (e) {
        e.preventDefault();
        $modalBox.hide();
    });


})();