/**
 * Created by Administrator on 2016/7/27.
 */
(()=> {
    const $form = $('#container .introducer');
    const $submit = $('input[type="submit"]', $form);
    const $introducerMobile = $('#introducerMobile', $form);
    const $projectDescription = $('#projectDescription', $form);
    const $errorPhone = $('.error-phone', $form);
    const $errorDescription = $('.error-description', $form);
    const $successDialog = $('.modal-box-success');

    const filterMobileInput = ($mobile)=> {
        $mobile.val(($mobile.val() + '').replace(/[^\d]/g, ''));
    };

    const validateMobile = ()=> {
        let mobile = $.trim($introducerMobile.val() + '');
        if (/^[\d]{11}$/g.test(mobile)) {
            $errorPhone.empty();
            return mobile;
        } else {
            $errorPhone.html('手机号输入错误!');
            return false;
        }
    };

    const validateDescription = ()=> {
        let description = $.trim($projectDescription.val() + '');
        if (description.length) {
            $errorDescription.empty();
            return description;
        } else {
            $errorDescription.html('请输入项目描述内容!');
            return false;
        }
    };

    $introducerMobile.on('keyup', (e)=> {
        filterMobileInput($introducerMobile);
    }).on('change blur', (e)=> {
        validateMobile();
    }).on('focus', (e)=> {
        $errorPhone.empty();
    });

    $projectDescription.on('change blur', (e)=> {
        validateDescription();
    }).on('focus', (e)=> {
        $errorDescription.empty();
    });


    $successDialog.on('click', '.modal-dialog-close', (e)=> {
        $successDialog.fadeOut(300);
    });

    $form.on('submit', (e)=> {
        e.preventDefault();
        let mobile = validateMobile();
        let description = validateDescription();
        if (mobile && description) {
            request('/api/1.0/proj/add.json', {
                mobile,
                description
            }, 'POST').done(()=> {
                $successDialog.fadeIn(300);
            }).fail(()=> {
                alert('提交失败, 请稍后再试!');
            });
            $introducerMobile.val('');
            $projectDescription.val('');
        }
    });
})();


(()=> {
    const $modalBox = $('.modal-box');

    let projectsList = [
        {
            'projectName':'中电投天津',
            'projectType':'保障房建设',
            'projectTime':'2年',
            'projectInfo':'用于补充公司现金流，承载天津市保障房建设。'
        },
        {
            'projectName':'中电投西安',
            'projectType':'基础建设项目',
            'projectTime':'2年',
            'projectInfo':'用于认购光大信托计划,用于向“绿源公司”发放信托贷款，用于建设西安绿源农产品批发市场项目。'
        },
        {
            'projectName':'金元百利海安',
            'projectType':'企业流贷',
            'projectTime':'3年',
            'projectInfo':'用于受让南通新沿海对海安经济技术开发区管委会的应收账款债 权,资金最终用于补充南通新沿海的流动资金。'
        },
        {
            'projectName':'中电投金堂',
            'projectType':'基础建设项目',
            'projectTime':'2年',
            'projectInfo':'用于认购光大信托先融锐金1号集合资金信托计划,补充公司流动资金,用于基础建设项目'
        },
        {
            'projectName':'国信巴中',
            'projectType':'基础建设项目',
            'projectTime':'2年',
            'projectInfo':'用于通江县壁州大道二期(高速连接道)建设项目用款。'
        },
        {
            'projectName':'枢纽铜仁',
            'projectType':'保障房建设项目',
            'projectTime':'18个月',
            'projectInfo':'用于贵州省铜仁市碧江区城市棚户区改造安置房项目'
        },
        {
            'projectName':'枢纽余庆',
            'projectType':'基础建设项目',
            'projectTime':'1年',
            'projectInfo':'用于贵州遵义市余庆县敖溪镇至关兴镇道路工程建设'
        },
        {
            'projectName':'中电投黔南州',
            'projectType':'基础建设项目',
            'projectTime':'2年',
            'projectInfo':'用于认购光大信托先融黔南1号集合资金信托计划,补充公司流 动资金,用于基础建设项目 '
        },
    ];

    const template = ({projectName, projectTime, projectType, projectInfo})=>{
        return `<h4>${projectName}</h4><h3>${projectTime}</h3><h6>${projectType}</h6><p>${projectInfo}</p>
        <img src="https://res.fudou6.com/c/4/20160801/zupNy5waWNfaGQ=_257x423.jpg">
        <a href="javascript:void('close');" class="modal-dialog-close">×</a>`;
    };

    const $modalDialog = $('.modal-dialog',$modalBox);

    $('.hot-project-address').on('click','a', (e)=> {
        e.preventDefault();
        var target=e.target;
        let html = '';
        let index = $(target).data(index).index;
        let project = projectsList[index];
        if(project){
            html= template(project);
            $modalDialog.html(html);
            $modalBox.fadeIn(300);

        }
    });

    $modalBox.on('click', '.modal-dialog-close', (e)=> {
        e.preventDefault();
        $modalBox.fadeOut(300);
    });


})();
