"use strict";

var _extends = Object.assign || function(e) {
    for (var t = 1; t < arguments.length; t++) {
        var n = arguments[t];
        for (var a in n) {
            if (Object.prototype.hasOwnProperty.call(n, a)) {
                e[a] = n[a];
            }
        }
    }
    return e;
};

var _createClass = function() {
    function e(e, t) {
        for (var n = 0; n < t.length; n++) {
            var a = t[n];
            a.enumerable = a.enumerable || false;
            a.configurable = true;
            if ("value" in a) a.writable = true;
            Object.defineProperty(e, a.key, a);
        }
    }
    return function(t, n, a) {
        if (n) e(t.prototype, n);
        if (a) e(t, a);
        return t;
    };
}();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(e) {
    return typeof e;
} : function(e) {
    return e && typeof Symbol === "function" && e.constructor === Symbol ? "symbol" : typeof e;
};

function _classCallCheck(e, t) {
    if (!(e instanceof t)) {
        throw new TypeError("Cannot call a class as a function");
    }
}

function request(e, t) {
    var n = arguments.length <= 2 || arguments[2] === undefined ? "GET" : arguments[2];
    var a = $.Deferred();
    $.ajax(e, {
        type: n,
        dataType: "json",
        data: t,
        success: function i(e) {
            if (e && e.status == 1) {
                a.resolve(e.result);
            } else {
                a.reject({
                    code: e && e.code || 0,
                    message: e && e.msg || e.message || "系统错误,请稍后再试!"
                });
            }
        },
        error: function s(e, t, n) {
            console.log(e, t, n);
            a.reject({
                code: e && e.status || t,
                message: n
            });
        }
    });
    return a;
}

function formatMoney() {
    var e = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
    var t = void 0;
    if (isNaN(e)) {
        t = "0";
    } else if (e >= 1e10) {
        t = e / 1e10 + "亿";
    } else if (e >= 1e6) {
        t = e / 1e6 + "万";
    } else {
        t = e / 100;
    }
    return t;
}

function deserialize() {
    var e = arguments.length <= 0 || arguments[0] === undefined ? location.search : arguments[0];
    var t = {};
    (e + "").replace(/^\?/g, "").split("&").forEach(function(e) {
        var n = (e + "").split("=");
        if (n.length) {
            t[decodeURIComponent(n[0])] = decodeURIComponent(n[1]);
        }
    });
    return t;
}

function serialize(e, t) {
    var n = [];
    Object.keys(e).map(function(a) {
        var i = e[a];
        if (a && typeof i !== "undefined") {
            var s = t ? t + "." + a : a;
            if ((typeof i === "undefined" ? "undefined" : _typeof(i)) == "object") {
                i = serialize(i, s);
                if (i) {
                    n.push(i);
                }
            } else {
                n.push(encodeURIComponent(s) + "=" + encodeURIComponent(i));
            }
        }
    });
    return n.length ? n.join("&") : "";
}

var Tabs = function() {
    function e(t) {
        _classCallCheck(this, e);
        this.options = _extends({
            activeClass: "active"
        }, t);
    }
    _createClass(e, [ {
        key: "initialize",
        value: function t() {
            this.container = $(this.options.container || "body").empty();
            this.render();
            return this;
        }
    }, {
        key: "findHeader",
        value: function n(e) {
            return this.element.find(".tabs-headers-item:eq(" + e + ")");
        }
    }, {
        key: "findPanel",
        value: function a(e) {
            return this.element.find(".tabs-panels-item:eq(" + e + ")");
        }
    }, {
        key: "selectIndex",
        value: function i(e) {
            var t = this.findHeader(this.activeIndex);
            var n = this.findPanel(this.activeIndex);
            if (typeof e === "number" && e !== this.activeIndex) {
                var a = this.options;
                var i = a.activeClass;
                var s = a.initializePanel;
                t.removeClass(i);
                n.removeClass(i);
                this.activeIndex = e;
                t = this.findHeader(e).addClass(i);
                n = this.findPanel(e).addClass(i);
                if (!n.attr("initialized")) {
                    if (typeof s === "function") {
                        s.call(this, e, t, n);
                    }
                    n.attr("initialized", true);
                }
            }
            return {
                header: t,
                panel: n
            };
        }
    }, {
        key: "render",
        value: function s() {
            var e = [];
            var t = [];
            var n = this;
            this.options.headers.forEach(function(n, a) {
                e.push('<a class="tabs-headers-item" data-index="' + a + '" href="javascript:void(\'' + n + "')\">" + n + "</a>");
                t.push('<div class="tabs-panels-item" data-index="' + a + '"></div>');
            });
            var a = '<div class="tabs">\n                            <div class="tabs-header">\n                                <div class="clear">\n                                   ' + e.join("") + '\n                                </div>\n                            </div>\n                            <div class="section">\n                                ' + t.join("") + "\n                            </div>\n                        </div>";
            this.element = $(a).appendTo(this.container);
            this.selectIndex(this.options.defaultIndex || 0);
            this.element.on("click", ".tabs-headers-item", function(e) {
                e.preventDefault();
                var t = $(this);
                var a = t.data("index");
                if (a != n.activeIndex) {
                    n.selectIndex(a);
                }
            });
            return this;
        }
    } ]);
    return e;
}();