'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// import "babel-polyfill";

function fetch(query, panel) {
    var data = _extends({}, query, { p: (parseInt(query.p, 10) || 1) - 1 });

    request('/api/1.0/prod/hList.json', data).done(function (_ref) {
        var hasNext = _ref.hasNext;
        var items = _ref.items;

        if (items && items.length) {
            var html = items.map(function (item) {
                return '<li data-id="' + item.id + '" class="product-item status-' + item.status + '">\n                <i class="seal">' + (item.status == 11 && item.fundRaisedTarget - item.fundRaisedOver > 0 ? '<span>' + formatMoney(item.fundRaisedTarget - item.fundRaisedOver) + '</span>' : '') + '</i>\n                <div class="clear main">\n                    <div class="main-left">\n                        <h2>' + item.itemShortTitle + '</h2>\n                        <h3>' + formatMoney(item.fundRaisedTarget) + '</h3>\n                        <div class="clear">\n                            <span class="main-left-01">\n                                <p>' + (item.productProspectiveReturn || '&nbsp;') + '</p>\n                            </span>\n                            <span class="main-left-02">\n                                <p>' + formatMoney(item.minimumAmount) + '</p>\n                            </span>\n                            <span class="main-left-03">\n                                <p>' + item.duration + '</p>\n                            </span>\n                        </div>\n                    </div>\n                    <div class="main-right">\n                        <div>\n                            <h4>项目亮点</h4>\n                            <p>' + item.summary + '</p>\n                        </div>\n                    </div>\n                </div>\n                <i class="corner"></i>\n            </li>';
            }).join('');
            $('.products', panel).html(html);
            var pagination = [];
            if (hasNext) {
                pagination.push('<a data-cate-id="' + data.cateId + '" data-p="' + (data.p + 2) + '" data-s="' + data.s + '" href="javascript:void(\'下一页\');">下一页</a>');
            }

            if (data.p >= 1) {
                pagination.unshift('<a data-cate-id="' + data.cateId + '" data-p="' + data.p + '" data-s="' + data.s + '" href="javascript:void(\'上一页\');">上一页</a>');
            }
            $('.pagination', panel).html(pagination.join(''));
            history.replaceState && history.replaceState(null, null, location.pathname + '?' + serialize(query));
        }
    }).fail(function (err) {
        console.log(err);
    });
}

function fetchCates(query) {
    request('/api/1.0/cate/cates.json').done(function (_ref2) {
        var pCates = _ref2.pCates;

        var cates = [];
        pCates.unshift({
            name: '全部',
            id: 'all'
        });
        pCates.forEach(function (cate) {
            !cate.selfPick && cates.push(cate.name);
        });
        var tabs = new Tabs({
            container: '.tabs',
            headers: cates,
            initializePanel: function initializePanel(index, header, panel) {
                var cate = pCates[index];
                var fetchQuery = cate.id == query.cateId ? query : { cateId: cate.id, p: 1, s: query.s || 10 };
                panel.html('<ul class="products"><li class="loading">正在努力加载中...</li></ul><ul class="pagination"></ul>');
                fetch(fetchQuery, panel);
            }
        });
        tabs.initialize();
        tabs.element.on('click', '.pagination a', function (e) {
            e.preventDefault();
            var data = $(this).data();
            fetch(data, tabs.findPanel(tabs.activeIndex));
            $(this).text('加载中...');
        }).on('click', '.product-item', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
            location.href = location.pathname + '/' + id;
        });
    });
}

fetchCates(deserialize());

//# sourceMappingURL=products.js.map