/**
 * Created by Administrator on 2016/7/27.
 */
(()=>{
    const $form = $('#container .introducer');
    const $introducerMobile = $('#introducerMobile', $form);
    const $projectDescription = $('#projectDescription', $form);
    const $errorPhone = $('.error-phone', $form);
    const $errorDescription =  $('.error-description', $form);

    const filterMobileInput = ($mobile)=>{
        $mobile.val(($mobile.val()+'').replace(/[^\d]/g, ''));
    };

    const validateMobile = (mobile)=>{
        return /^[\d]{11}$/g.test(mobile);
    };

    const validateRequire = (value)=>{
        return value.length;
    };

    $introducerMobile.on('keyup', (e)=>{
        filterMobileInput($introducerMobile);
    }).on('change blur', (e)=>{
        validateMobile($.trim($introducerMobile.val()+'')) ?
            $errorPhone.empty() :
            $errorPhone.html('手机号输入错误!');
    });

    $projectDescription.on('change blur', (e)=>{
        validateRequire($.trim($projectDescription.val()+'')) ?
            $errorDescription.empty() :
            $errorDescription.html('请输入项目描述内容!');
    });

    $form.on('submit', (e)=>{
        let mobile = $.trim($introducerMobile.val()+'');
        let desc = $.trim($projectDescription.val()+'');
        if(validateMobile(mobile)){
            $errorPhone.empty()
        }else{
            $errorPhone.html('手机号输入错误!');
            return;
        }
        if(validateRequire(desc)){
            $errorDescription.empty()
        }else {
            $errorDescription.html('请输入项目描述内容!');
            return;
        }
        request('', {}, 'POST').then((result)=>{
            console.log(result);
        });
    });
})();

(function () {
    var $submit = $('#submit');
    var $errorPhone = $('.error-phone');
    var $errorDescription = $('.error-description');
    var $introducerMobile = $('#introducerMobile');
    var $projectDescription = $('#projectDescription');
    var $modalBoxProject = $('.modal-box-project');
    var $modalBoxSuccess = $('.modal-box-success');
    var $introducer = $('#introducer');



    /**
     * 验证手机号
     * @param tel
     * @returns {boolean}
     */
    function valiTel(tel) {
        var msg = /^[\d]/g.test(tel) ? '' : '电话号码有误，请再次输入！';
        //!msg && $introducerMobile.val('');
        /^[\d]/g.test(tel[tel.length-1])? $introducerMobile.val(tel) : $introducerMobile.val(tel.slice(0,tel.length-1));
        console.log(tel[tel.length-1]);
        console.log(/^[\d]/g.test(tel[tel.length-1]));
        !msg && $errorPhone.html(msg);
        $errorPhone.data('vali', !msg);
        disableSubmit();
        return !msg;
    }

    /**
     * 验证项目描述不能为空
     * @param text
     * @returns {boolean}
     */
    function valiDescription(text) {
        $errorDescription.html(text ? '' : '项目描述不能为空!');
        $errorDescription.data('vali', text);
        disableSubmit();
        return !text;
    }

    /**
     * 提交按钮是否可用
     */
    function disableSubmit() {
        $errorPhone.data('vali') && $errorDescription.data('vali') &&
        $submit.attr('disabled', false).css('background', '#ff4a4b');
    }

    $introducerMobile.on({
        keyup: function (e) {
            valiTel(($introducerMobile.val() + '').trim());
        }
    });
    $projectDescription.on({
        keyup: function (e) {
            valiDescription(($projectDescription.val() + '').trim());
        }
    });
    /*
     * 不需要在再次验证
     $introducer.on('submit', function (e) {
     if (!valiTel(($introducerMobile.val() + '').trim())) {
     $introducerMobile.focus();
     $errorPhone.html('电话号码有误!');
     e.preventDefault();
     return;
     }
     if (valiDescription(($projectDescription.val() + '').trim())) {
     $projectDescription.focus();
     $errorDescription.html('项目描述不能为空!');
     e.preventDefault();
     return;
     }
     });
     */

    /**
     * 地图项目地址弹框
     */
    $('.hot-project-address a').click(function (e) {
        e.preventDefault();
        $modalBox.fadeIn(300);
    });
    $('#modalBoxHidden').click(function (e) {
        e.preventDefault();
        $modalBox.fadeOut(300);
    });

    /**
     * 项目提交弹框
     */
    $submit.on('click',function(e){
        e.preventDefault();
        $modalBoxSuccess.fadeIn(300);
    });
    $('.modal-box-success a').on('click',function(e){
        e.preventDefault();
        $modalBoxSuccess.fadeOut(300);
    });


})();