"use strict";

var _extends = Object.assign || function(a) {
    for (var n = 1; n < arguments.length; n++) {
        var t = arguments[n];
        for (var i in t) {
            if (Object.prototype.hasOwnProperty.call(t, i)) {
                a[i] = t[i];
            }
        }
    }
    return a;
};

function fetch(a, n) {
    var t = _extends({}, a, {
        p: (parseInt(a.p, 10) || 1) - 1
    });
    request("/api/1.0/prod/hList.json", t).done(function(i) {
        var e = i.hasNext;
        var s = i.items;
        if (s && s.length) {
            var r = s.map(function(a) {
                return '<li data-id="' + a.id + '" class="product-item status-' + a.status + '">\n                <i class="seal">' + (a.status == 11 && a.fundRaisedTarget - a.fundRaisedOver > 0 ? "<span>" + formatMoney(a.fundRaisedTarget - a.fundRaisedOver) + "</span>" : "") + '</i>\n                <div class="clear">\n                    <div>\n                        <h2>' + a.itemShortTitle + "</h2>\n                        <h3>" + formatMoney(a.fundRaisedTarget) + '</h3>\n                        <div class="clear">\n                            <span>\n                                <p>' + a.commissionMaxDur + "</p>\n                            </span>\n                            <span>\n                                <p>" + formatMoney(a.minimumAmount) + "</p>\n                            </span>\n                            <span>\n                                <p>" + a.duration + "</p>\n                            </span>\n                        </div>\n                    </div>\n                    <div>\n                        <div>\n                            <h4>项目亮点</h4>\n                            <p>" + a.summary + '</p>\n                        </div>\n                    </div>\n                </div>\n                <i class="corner"></i>\n            </li>';
            }).join("");
            $(".products", n).html(r);
            var c = [];
            if (e) {
                c.push('<a data-cate-id="' + t.cateId + '" data-p="' + (t.p + 2) + '" data-s="' + t.s + '" href="javascript:void(\'下一页\');">下一页</a>');
            }
            if (t.p >= 1) {
                c.unshift('<a data-cate-id="' + t.cateId + '" data-p="' + t.p + '" data-s="' + t.s + '" href="javascript:void(\'上一页\');">上一页</a>');
            }
            $(".pagination", n).html(c.join(""));
            history.replaceState && history.replaceState(null, null, location.pathname + "?" + serialize(a));
        }
    }).fail(function(a) {
        console.log(a);
    });
}

function fetchCates(a) {
    request("/api/1.0/cate/cates.json").done(function(n) {
        var t = n.pCates;
        var i = [];
        t.unshift({
            name: "全部",
            id: "all"
        });
        t.forEach(function(a) {
            !a.selfPick && i.push(a.name);
        });
        var e = new Tabs({
            container: ".tabs",
            headers: i,
            initializePanel: function s(n, i, e) {
                var s = t[n];
                var r = s.id == a.cateId ? a : {
                    cateId: s.id,
                    p: 1,
                    s: a.s || 10
                };
                e.html('<ul class="products"><li class="loading">正在努力加载中...</li></ul><ul class="pagination"></ul>');
                fetch(r, e);
            }
        });
        e.initialize();
        e.element.on("click", ".pagination a", function(a) {
            a.preventDefault();
            var n = $(this).data();
            fetch(n, e.findPanel(e.activeIndex));
            $(this).text("加载中...");
        }).on("click", ".product-item", function(a) {
            a.preventDefault();
            var n = $(this).data("id");
            location.href = location.pathname + "/" + n;
        });
    });
}

fetchCates(deserialize());