'use strict';

/**
 * Created by Administrator on 2016/7/27.
 */
(function () {
    var $form = $('#container .introducer');
    var $introducerMobile = $('#introducerMobile', $form);
    var $projectDescription = $('#projectDescription', $form);
    var $errorPhone = $('.error-phone', $form);
    var $errorDescription = $('.error-description', $form);

    var filterMobileInput = function filterMobileInput($mobile) {
        $mobile.val(($mobile.val() + '').replace(/[^\d]/g, ''));
    };

    var validateMobile = function validateMobile(mobile) {
        return (/^[\d]{11}$/g.test(mobile)
        );
    };

    var validateRequire = function validateRequire(value) {
        return value.length;
    };

    $introducerMobile.on('keyup', function (e) {
        filterMobileInput($introducerMobile);
    }).on('change blur', function (e) {
        validateMobile($.trim($introducerMobile.val() + '')) ? $errorPhone.empty() : $errorPhone.html('手机号输入错误!');
    });

    $projectDescription.on('change blur', function (e) {
        validateRequire($.trim($projectDescription.val() + '')) ? $errorDescription.empty() : $errorDescription.html('请输入项目描述内容!');
    });

    $form.on('submit', function (e) {
        var mobile = $.trim($introducerMobile.val() + '');
        var desc = $.trim($projectDescription.val() + '');
        if (validateMobile(mobile)) {
            $errorPhone.empty();
        } else {
            $errorPhone.html('手机号输入错误!');
            return;
        }
        if (validateRequire(desc)) {
            $errorDescription.empty();
        } else {
            $errorDescription.html('请输入项目描述内容!');
            return;
        }
        request('', {}, 'POST').then(function (result) {
            console.log(result);
        });
    });
})();

(function () {
    var $modalBox = $('.modal-box');

    $('.hot-project-address').on('click', 'a', function (e) {
        e.preventDefault();
        $modalBox.fadeIn(300);
    });

    $modalBox.on('click', '.modal-dialog-close', function (e) {
        e.preventDefault();
        $modalBox.fadeOut(300);
    });
})();

// (function () {
//
//
//
//
//
//     var $modalBoxProject = $('.modal-box-project');
//     var $modalBoxSuccess = $('.modal-box-success');
//
//
//
//
//     /**
//      * 地图项目地址弹框
//      */
//     $('.hot-project-address a').click(function (e) {
//         e.preventDefault();
//         $modalBox.fadeIn(300);
//     });
//     $('#modalBoxHidden').click(function (e) {
//         e.preventDefault();
//         $modalBox.fadeOut(300);
//     });
//
//     /**
//      * 项目提交弹框
//      */
//     $submit.on('click',function(e){
//         e.preventDefault();
//         $modalBoxSuccess.fadeIn(300);
//     });
//     $('.modal-box-success a').on('click',function(e){
//         e.preventDefault();
//         $modalBoxSuccess.fadeOut(300);
//     });
//
//
// })();

//# sourceMappingURL=project.js.map