 function request(url, data, method = 'GET') {
    return new Promise((resolve, reject)=> {
        $.ajax(url, {
            type: method,
            dataType: 'json',
            data,
            success: res=> {
                if (res && res.status == 1) {
                    resolve(res.result);
                } else {
                    reject({
                        code: res && res.code || 0,
                        message: res && res.msg || res.message || '系统错误,请稍后再试!'
                    });
                }
            },
            error: (xhr, status, text)=> {
                console.log(xhr, status, text);
                reject({
                    code: xhr && xhr.status || status,
                    message: text
                });
            }
        });
    });
}

 function formatMoney(money = 0) {
    let ret;
    if (isNaN(money)) {
        ret = '0';
    } else if (money >= 1E10) {
        ret = (money / 1E10) + '亿';
    } else if (money >= 1E6) {
        ret = (money / 1E6) + '万';
    } else {
        ret = (money / 1E2);
    }
    return ret;
}

 function deserialize(str = location.search) {
    const query = {};
    (str + '').replace(/^\?/g, '').split('&').forEach(item=> {
        let tmp = (item + '').split('=');
        if (tmp.length) {
            query[decodeURIComponent(tmp[0])] = decodeURIComponent(tmp[1]);
        }
    });
    return query;
}

 function serialize(obj, prefix) {
    var str = [];
    Object.keys(obj).map(p=> {
        let v = obj[p];
        if (p && typeof v !== 'undefined') {
            let k = prefix ? prefix + "." + p : p;
            if (typeof v == 'object') {
                v = serialize(v, k);
                if (v) {
                    str.push(v);
                }
            } else {
                str.push(encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
    });
    return str.length ? str.join("&") : '';
}

 class Tabs {
    constructor(options) {
        this.options = {activeClass: 'active', ...options};
    }

    initialize() {
        this.container = $(this.options.container || 'body').empty();
        this.render();
        return this;
    }

    findHeader(index) {
        return this.element.find('.tabs-headers-item:eq(' + index + ')');
    }

    findPanel(index) {
        return this.element.find('.tabs-panels-item:eq(' + index + ')');
    }

    selectIndex(index) {

        let header = this.findHeader(this.activeIndex);
        let panel = this.findPanel(this.activeIndex);

        if (typeof index === 'number' && index !== this.activeIndex) {
            const {activeClass, initializePanel} = this.options;
            header.removeClass(activeClass);
            panel.removeClass(activeClass);
            this.activeIndex = index;
            header = this.findHeader(index).addClass(activeClass);
            panel = this.findPanel(index).addClass(activeClass);
            if (!panel.attr('initialized')) {
                if (typeof initializePanel === 'function') {
                    initializePanel.call(this, index, header, panel);
                }
                panel.attr('initialized', true);
            }
        }
        return {
            header,
            panel
        };
    }

    render() {
        const headers = [];
        const panels = [];
        const self = this;
        this.options.headers.forEach((item, index)=> {
            headers.push(`<a class="tabs-headers-item" data-index="${index}" href="javascript:void('${item}')">${item}</a>`);
            panels.push(`<div class="tabs-panels-item" data-index="${index}"></div>`);
        });
        const html = `<div class="tabs">
                            <header class="tabs-header">
                                <div class="clear">
                                   ${headers.join('')}
                                </div>
                            </header>
                            <section>
                                ${panels.join('')}
                            </section>
                        </div>`;
        this.element = $(html).appendTo(this.container);

        this.selectIndex(this.options.defaultIndex || 0);

        this.element.on('click', '.tabs-headers-item', function (e) {
            e.preventDefault();
            const tabHeader = $(this);
            const index = tabHeader.data('index');
            if (index != self.activeIndex) {
                self.selectIndex(index);
            }
        });
        return this;
    }


}