/**
 * Created by Administrator on 2016/7/26.
 */
(function () {

    var $form = $('#form');
    var $userName = $('input[name="userName"]', $form);
    var $userTel = $('input[name="userTel"]', $form);
    var $errorName = $('.appointment .errorName');
    var $errorTel = $('.appointment .errorTel');
    var $modalBox=$('.modal-box');

    var balance = $('.balance').html();
    var total = $('.total').html();
    var progress = $('.progress-bar i');
    progress.width(progress.data('width'));
    /**
     * 验证用户姓名
     * @param obj
     * @returns {boolean}
     */
    function valiUserName(userName) {
        $errorName.html(userName ? '' : '请输入您的姓名！');
        return !userName;
    }

    function filterNotNumber(mobile) {
        if (/[^\d]/g.test(mobile)) {
            $userTel.val(mobile.replace(/[^\d]/g, ''));
            return false;
        }
        return true;
    }

    /**
     * 验证电话号码
     * @param obj
     * @returns {boolean}
     */
    function valiMobile(mobile) {
        if (/^[\d]{11}$/g.test(mobile)) {
            $errorTel.html('');
            return false;
        }
        $errorTel.html('手机号有误，请重新输入！');
        return true;
    }

    $userName.on('keyup', function () {
        valiUserName($.trim($userName.val() + ''));
    });
    $userTel.on('keyup', function () {
        var mobile = $userTel.val();
        filterNotNumber(mobile);
        valiMobile(mobile);
    });

    /**
     * 提交验证
     */
    $form.on('submit', function (e) {
        e.preventDefault();
        if (valiUserName($.trim($userName.val() + ''))) {
            $userName.focus();
            return;
        }
        if (valiMobile($.trim($userTel.val() + ''))) {
            $userTel.focus();
            return;
        }

        request()

        $modalBox.fadeIn(300);
    });

    $('#modalBoxHidden').click(function (e) {
        e.preventDefault();
        $modalBox.fadeOut(300);
    });


})();
