(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['module', 'exports', '../utils/xFetch', 'express'], factory);
    } else if (typeof exports !== "undefined") {
        factory(module, exports, require('../utils/xFetch'), require('express'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod, mod.exports, global.xFetch, global.express);
        global.product = mod.exports;
    }
})(this, function (module, exports, _xFetch, express) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.formatDateTime = exports.leftPad = exports.productStatusToString = exports.PRODUCT_STATUS = undefined;
    exports.formatMoney = formatMoney;

    var _xFetch2 = _interopRequireDefault(_xFetch);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var PRODUCT_STATUS = exports.PRODUCT_STATUS = {
        '-9': '草稿',
        0: '已删除',
        1: '未发布',
        5: '预热中',
        11: '募集中',
        17: '已暂停',
        21: '已封账',
        31: '已成立'
    };

    var productStatusToString = exports.productStatusToString = function productStatusToString(status) {
        return PRODUCT_STATUS[status] || '未定义';
    };

    function formatMoney() {
        var money = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];

        var ret = void 0;
        if (isNaN(money)) {
            ret = '0';
        } else if (money >= 1E10) {
            ret = money / 1E10 + '亿';
        } else if (money >= 1E6) {
            ret = money / 1E6 + '万';
        } else {
            ret = money / 1E2;
        }
        return ret;
    }

    var leftPad = exports.leftPad = function leftPad(num) {
        return num >= 10 ? num : '0' + num;
    };

    var formatDateTime = exports.formatDateTime = function formatDateTime() {
        var time = arguments.length <= 0 || arguments[0] === undefined ? 0 : arguments[0];
        var format = arguments.length <= 1 || arguments[1] === undefined ? 'YYYY-MM-DD hh:mm:ss' : arguments[1];

        var date = new Date(time);
        var data = {
            YYYY: date.getFullYear(),
            MM: leftPad(date.getMonth() + 1),
            DD: leftPad(date.getDate()),
            hh: leftPad(date.getHours()),
            mm: leftPad(date.getMinutes()),
            ss: leftPad(date.getSeconds())
        };
        return format.replace(/[A-Za-z]+/g, function (metch) {
            return data[metch];
        });
    };

    module.exports = function (req, res, next) {
        Promise.all([(0, _xFetch2.default)('https://m.fudou6.com/api/1.0/cate/cates.json'), (0, _xFetch2.default)('https://m.fudou6.com/api/1.0/prod/detail.json?itemId=' + req.params.id)]).then(function (arr) {
            var pCates = arr[0].pCates;
            var item = arr[1].item;


            if (!item || !pCates) {
                var err = new Error('Not Found');
                err.status = 404;
                next(err);
            }

            pCates.forEach(function (cate) {
                cate.subCates.forEach(function (scate) {
                    if (scate.id == item.categoryId) {
                        item.categoryName = scate.name;
                        item.categoryParentId = cate.id;
                        item.categroyParentName = cate.name;
                    }
                });
            });

            item.elements = JSON.parse(item.elements);

            Object.keys(item.elements).forEach(function (key) {
                console.log('%s\t%s\t%s', key, item.elements[key][0], item.elements[key][1]);
                item.elements[key] = item.elements[key][1];
            });

            item.commissionAlg = JSON.parse(item.commissionAlg);

            item.commissionAlg = item.commissionAlg.map(function (it) {
                var _ref = it.result || {};

                var sy = _ref.sy;
                var yj = _ref.yj;

                return {
                    rowspan: item.commissionAlg.length,
                    range: (it.min ? formatMoney(it.min) + ' ≤ ' : '') + ' x ' + (it.max ? ' < ' + formatMoney(it.max) : ''),
                    min: it.min,
                    max: it.max,
                    sy: sy, yj: yj
                };
            });

            item.fundRaisedStartTimeString = item.fundRaisedStartTime && formatDateTime(item.fundRaisedStartTime);
            item.fundRaisedEndTimeString = item.fundRaisedEndTime && formatDateTime(item.fundRaisedEndTime);

            item.statusString = productStatusToString(item.status);

            //募集目标
            item.fundRaisedTargetString = formatMoney(item.fundRaisedTarget);
            //已募集
            item.fundRaisedOverString = formatMoney(item.fundRaisedOver);
            item.fundRaisedPercentage = item.fundRaisedOver / item.fundRaisedTarget * 100;
            //募集剩余
            item.fundRaisedSurplus = Math.max(item.fundRaisedTarget - item.fundRaisedOver, 0);

            item.fundRaisedSurplusString = formatMoney(item.fundRaisedSurplus);
            //最小投资
            item.minimumAmountString = formatMoney(item.minimumAmount);

            //console.log(item);

            res.render('product', _extends({
                styles: ['product'],
                scripts: ['utils', 'product']
            }, item));
        }).catch(function (err) {
            console.log(err);
            next(err);
        });
    };
});

//# sourceMappingURL=product.js.map