/**
 * Created by Administrator on 2016/7/27.
 */
(()=> {
    const $form = $('#container .introducer');
    const $submit = $('input[type="submit"]', $form);
    const $introducerMobile = $('#introducerMobile', $form);
    const $projectDescription = $('#projectDescription', $form);
    const $errorPhone = $('.error-phone', $form);
    const $errorDescription = $('.error-description', $form);
    const $successDialog = $('.modal-box-success');

    const filterMobileInput = ($mobile)=> {
        $mobile.val(($mobile.val() + '').replace(/[^\d]/g, ''));
    };

    const validateMobile = ()=> {
        let mobile = $.trim($introducerMobile.val() + '');
        if (/^[\d]{11}$/g.test(mobile)) {
            $errorPhone.empty();
            return mobile;
        } else {
            $errorPhone.html('手机号输入错误!');
            return false;
        }
    };

    const validateDescription = ()=> {
        let description = $.trim($projectDescription.val() + '');
        if (description.length) {
            $errorDescription.empty();
            return description;
        } else {
            $errorDescription.html('请输入项目描述内容!');
            return false;
        }
    };

    $introducerMobile.on('keyup', (e)=> {
        filterMobileInput($introducerMobile);
    }).on('change blur', (e)=> {
        validateMobile();
    }).on('focus', (e)=> {
        $errorPhone.empty();
    });

    $projectDescription.on('change blur', (e)=> {
        validateDescription();
    }).on('focus', (e)=> {
        $errorDescription.empty();
    });


    $successDialog.on('click', '.modal-dialog-close', (e)=> {
        $successDialog.fadeOut(300);
    });

    $form.on('submit', (e)=> {
        e.preventDefault();
        let mobile = validateMobile();
        let description = validateDescription();
        if (mobile && description) {
            request('/api/1.0/proj/add.json', {
                mobile,
                description
            }, 'POST').then(()=> {
                $successDialog.fadeIn(300);
            }).catch(()=> {
                alert('提交失败, 请稍后再试!');
            });
        }
    });
})();

(()=> {
    const $modalBox = $('.modal-box');

    $('.hot-project-address').on('click', 'a', (e)=> {
        e.preventDefault();
        $modalBox.fadeIn(300);
    });

    $modalBox.on('click', '.modal-dialog-close', (e)=> {
        e.preventDefault();
        $modalBox.fadeOut(300);
    });


})();


// (function () {
//
//
//
//
//
//     var $modalBoxProject = $('.modal-box-project');
//     var $modalBoxSuccess = $('.modal-box-success');
//
//
//
//
//     /**
//      * 地图项目地址弹框
//      */
//     $('.hot-project-address a').click(function (e) {
//         e.preventDefault();
//         $modalBox.fadeIn(300);
//     });
//     $('#modalBoxHidden').click(function (e) {
//         e.preventDefault();
//         $modalBox.fadeOut(300);
//     });
//
//     /**
//      * 项目提交弹框
//      */
//     $submit.on('click',function(e){
//         e.preventDefault();
//         $modalBoxSuccess.fadeIn(300);
//     });
//     $('.modal-box-success a').on('click',function(e){
//         e.preventDefault();
//         $modalBoxSuccess.fadeOut(300);
//     });
//
//
// })();