var express = require('express');
var router = express.Router();

var product = require('./product');

/* GET home page. */
router.get('/', function (req, res) {
    res.render('index', {
        navIndex:'active',
        styles: ['index'],
        env: process.env.NODE_ENV === 'production' ? 'production': '',
        scripts:[],
        character: [
            {
                sum: '526亿',
                text: '累计交易',
                img: '/images/index/picture_01.png',
                c1: '金融脱媒',
                c2: '一手资源，从融资方直接取得项目资源'
            },
            {
                sum: '3075位',
                text: '精英理财师数',
                img: '/images/index/picture_02.png',
                c1: '严格风控',
                c2: '原招商银行风控团队'
            },
            {
                sum: '335款',
                text: '发行产品数',
                img: '/images/index/picture_03.png',
                c1: '快速结拥',
                c2: '新用户款到结拥'
            },
            {
                sum: '3.7亿',
                text: '累计发行佣金',
                img: '/images/index/picture_04.png',
                c1: '佣金超高',
                c2: '高于市场千八的佣金体系'
            },
        ],
        products: [
            {
                title: '中电投先融-西安灞桥',
                img: 'http://res.fudou6.com/c/4/20160730/c4sNTI4YWQ1Nw==_1000x600.jpg',
                raiseTime: '28',
                raiseFunds: '4',
                maxProfits: '8.5%',
                link: '/products/20010'
            }, {
                title: '中电投先融-天津市级政信',
                img: 'http://res.fudou6.com/c/4/20160730/m3gMDQxYzBjYw==_1000x600.jpg',
                raiseTime: '28',
                raiseFunds: '5',
                maxProfits: '8.3%',
                link: '/products/20011'
            }, {
                title: '中电投先融-锐金1-2号',
                img: 'http://res.fudou6.com/c/4/20160730/eedZmNmYmIwOA==_600x375.jpg',
                raiseTime: '21',
                raiseFunds: '2',
                maxProfits: '8.7%',
                link: '/products/20012'
            }, {
                title: '金元南通新沿海1号',
                img: 'http://res.fudou6.com/c/4/20160730/y3sNWNlN2NmOA==_1000x600.jpg',
                raiseTime: '20',
                raiseFunds: '2',
                maxProfits: '8.5%',
                link: '/products/20008'
            }, {
                title: '国信证券<br/>巴中市高明新区壁州大道',
                img: 'http://res.fudou6.com/c/4/20160730/pdeMzhiZTc4ZA==_1000x600.jpg',
                raiseTime: '52',
                raiseFunds: '1',
                maxProfits: '10.6%',
                link: '/products/20013'
            },
        ]
    });
});

router.get('/about', function (req, res) {
    res.render('about', {
        navAbout:'active',
        styles: ['about'],
        env: process.env.NODE_ENV === 'production' ? 'production': '',
    });
});

router.get('/project', function (req, res) {
    res.render('project', {
        navProject:'active',
        styles: ['project'],
        scripts:['utils','project'],
        env: process.env.NODE_ENV === 'production' ? 'production': '',
    });
});




router.get('/products', function (req, res) {

    res.render('products', {
        navProducts:'active',
        styles: ['products'],
        scripts:['utils','products'],
        env: process.env.NODE_ENV === 'production' ? 'production': '',
    });
});
router.get('/products/:id', product);


module.exports = router;
