/**
 * Created by liaili on 16/8/10.
 */
import './product.html';
const styles = require('./product.less');


import $ from 'jquery';

(function () {

    const data = {
        id: 5005,
        raised: 80000000,
        total: 200000000,
        sealTime: '2016-09-01 12:00:00'
    };

    const $arrow = $('.arrow');
    $arrow.css('animation-name',styles['arrow-change']);

    function formatMoney(money = 0) {
        let ret;
        if (isNaN(money)) {
            ret = '0'
        } else if (money >= 1E8) {
            ret = (money / 1E8) + '亿';
        } else if (money >= 1E4) {
            ret = money / 1E4 + '万';
        } else {
            ret = money;
        }
        return ret;
    }

    function projectStatus(data) {
        let html;
        switch (data.id) {
            case 5001 :
                html = '预热中';
                break;
            case 5002 :
                html = '已成立';
                break;
            case 5003 :
                html = '已封账';
                break;
            case 5004 :
                html = '暂停中';
                break;
            case 5005 :
                html = data.sealTime === 'undefined' ? '募集中' : '预计封账时间: ' + data.sealTime;
                break;
        }
        return html;
    }

    $('.status').html(projectStatus(data));
    let parcent = ((data.total - data.raised) / data.total).toFixed(2) * 100 + '%';
    $('span', '.circle').html(parcent);
    $('i', '.circle').height($('.circle').height() * data.raised / data.total.toFixed(2));
    $('h3', '.project-status-img').html(formatMoney(data.raised) + ' / ' + formatMoney(data.total));


})();





