/**
 * Created by liaili on 16/8/9.
 */
import './navitation.html';
import './navitation.less';

// import $ from 'jquery';
var $ = require("jquery");

(function () {
    const $loading = $('.loading');
    const $modalBox = $('.modal-box');
    const $modalBoxContent = $('p',$modalBox);
    const $modalBoxHidden = $('a', $modalBox);
    const $mobile = $('#mobile');

    /*手机号验证 start*/
    const filterMobileInput = ($mobile)=> {
        $mobile.val($mobile.val().replace(/[^\d]/g, ''));
    };
    const validataMobile = ()=> {
        if ( /^\d{11}$/g.test( $.trim( $mobile.val() ) ) ) {
            return mobile;
        } else {
            return false;
        }
    };

    /*号码传到数据库 start*/
    function request(url, data, method = 'GET') {
        let promise = $.Deferred();
        $.ajax(url, {
            type: method,
            dataType: 'json',
            data,
            success: res=> {
                if (res && res.status == 1) {
                    promise.resolve(res.result);
                } else {
                    promise.reject({
                        code: res && res.code || 0,
                        message: res && res.msg || res.message || '系统错误,请稍后再试!'
                    });
                }
            },
            error: (xhr, status, text)=> {
                console.log(xhr, status, text);
                promise.reject({
                    code: xhr && xhr.status || status,
                    message: text
                });
            }
        });
        return promise;
    }
    /*号码传到数据库 end*/

    $mobile.on('keyup', (()=> {
        filterMobileInput($mobile);
    }));

    /*手机号验证 end*/

    /*错误提示框消逝 start*/
    $modalBoxHidden.on('click', ()=> {
        $modalBox.fadeOut(500);
    });
    /*错误提示框消逝 end*/

    /*判断安卓和IOS start*/
    function judgePhoneSystem($loading) {
        let ua = navigator.userAgent.toLowerCase();
        if (/iphone|ipad|ipod/.test(ua)) {
            $loading.attr('href', 'https://itunes.apple.com/cn/app/fu-dou-you-tou/id1125652968?mt=8')
        } else if (/android/.test(ua)) {
            $loading.attr('href', 'http://android.myapp.com/myapp/detail.htm?apkName=com.fudou6.app')
        }
    }
    /*判断安卓和IOS end*/

    /*弹框提示内容 start*/
    function modalBoxContent(content){
        $modalBoxContent.html(content);
    }
    /*弹框提示内容 end*/

    $loading.on('click', ()=> {
        let validataInput = validataMobile();
        let mobile = $mobile.val();
        if(validataInput){
            request('/api/1.0/proj/add.json', mobile, 'POST').done(()=> {
                judgePhoneSystem($loading);
            }).fail(()=> {
                $modalBoxContent.html('提交失败, 请稍后再试!');
                $modalBox.fadeIn(500);
            });

        }else {
            $modalBoxContent.html('请检查手机号码!');
            $modalBox.fadeIn(500);
        }
        $mobile.val('');
    });

})();







